/*
 * Decompiled with CFR 0.152.
 */
package pl.redlink.push.analytics;

import android.annotation.SuppressLint;
import android.content.Context;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.redlink.push.Logger;
import pl.redlink.push.database.Event;
import pl.redlink.push.database.EventsDatabaseHelper;
import pl.redlink.push.extension.StringKt;
import pl.redlink.push.service.EventsService;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0010H\u0002J\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0012\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0002J5\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00042\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00102\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\u001aJ \u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J \u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u000eH\u0007J \u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0006H\u0007J \u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0007J2\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00042\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00102\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lpl/redlink/push/analytics/RedlinkAnalytics;", "", "()V", "CHAR_SPACE", "", "MAX_ADDITIONAL_KEY_NAME_LENGTH", "", "MAX_EVENT_NAME_LENGTH", "TIME_DIVIDER", "context", "Landroid/content/Context;", "eventsDatabaseHelper", "Lpl/redlink/push/database/EventsDatabaseHelper;", "areParamsValid", "", "params", "", "init", "", "init$push_release", "isEventNameValid", "name", "isUserDataValid", "userDataJson", "prepareEvent", "Lpl/redlink/push/database/Event;", "prepareEvent$push_release", "trackEvent", "key", "value", "Ljava/util/Date;", "push_release"})
@SuppressLint(value={"StaticFieldLeak"})
public final class RedlinkAnalytics {
    private static final int MAX_EVENT_NAME_LENGTH = 64;
    private static final int MAX_ADDITIONAL_KEY_NAME_LENGTH = 64;
    private static final String CHAR_SPACE = " ";
    private static final int TIME_DIVIDER = 1000;
    private static Context context;
    private static EventsDatabaseHelper eventsDatabaseHelper;
    public static final RedlinkAnalytics INSTANCE;

    public final /* synthetic */ void init$push_release(@NotNull Context context, @NotNull EventsDatabaseHelper eventsDatabaseHelper) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)eventsDatabaseHelper), (String)"eventsDatabaseHelper");
        RedlinkAnalytics.context = context;
        RedlinkAnalytics.eventsDatabaseHelper = eventsDatabaseHelper;
    }

    @JvmStatic
    public static final void trackEvent(@NotNull String name, @NotNull Map<String, ? extends Object> params, @Nullable String userDataJson) {
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(params, (String)"params");
            if (!INSTANCE.isEventNameValid(name)) {
                Logger.INSTANCE.error("Invalid event name -> " + name + " (Event names can be up to 64, can't contain spaces");
                return;
            }
            if (!INSTANCE.areParamsValid(params)) {
                return;
            }
            if (!INSTANCE.isUserDataValid(userDataJson)) {
                Logger.INSTANCE.error("Invalid JSON content in userData");
                return;
            }
            EventsDatabaseHelper eventsDatabaseHelper = RedlinkAnalytics.eventsDatabaseHelper;
            if (eventsDatabaseHelper != null) {
                eventsDatabaseHelper.insertEvent(INSTANCE.prepareEvent$push_release(name, params, userDataJson));
            }
            Context context = RedlinkAnalytics.context;
            if (context == null) break block4;
            Context context2 = context;
            boolean bl = false;
            boolean bl2 = false;
            Context it = context2;
            boolean bl3 = false;
            EventsService.Companion.enqueueRequest(it);
        }
    }

    public static /* synthetic */ void trackEvent$default(String string, Map map, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        RedlinkAnalytics.trackEvent(string, map, string2);
    }

    @JvmStatic
    public static final void trackEvent(@NotNull String name, @NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        RedlinkAnalytics.trackEvent$default(name, MapsKt.mapOf((Pair)TuplesKt.to((Object)key, (Object)value)), null, 4, null);
    }

    @JvmStatic
    public static final void trackEvent(@NotNull String name, @NotNull String key, int value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        RedlinkAnalytics.trackEvent$default(name, MapsKt.mapOf((Pair)TuplesKt.to((Object)key, (Object)value)), null, 4, null);
    }

    @JvmStatic
    public static final void trackEvent(@NotNull String name, @NotNull String key, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        RedlinkAnalytics.trackEvent$default(name, MapsKt.mapOf((Pair)TuplesKt.to((Object)key, (Object)value)), null, 4, null);
    }

    @JvmStatic
    public static final void trackEvent(@NotNull String name, @NotNull String key, @NotNull Date value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        RedlinkAnalytics.trackEvent$default(name, MapsKt.mapOf((Pair)TuplesKt.to((Object)key, (Object)value)), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Event prepareEvent$push_release(@NotNull String name, @NotNull Map<String, ? extends Object> params, @Nullable String userDataJson) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        Event event = new Event(0, name, System.currentTimeMillis() / (long)1000, null, null, null, null, userDataJson, 121, null);
        Object object = params;
        boolean bl = false;
        for (Map.Entry<String, ? extends Object> entry : object.entrySet()) {
            void key;
            Object object2 = entry;
            boolean bl2 = false;
            object = object2.getKey();
            object2 = entry;
            bl2 = false;
            Object value = object2.getValue();
            if ((object2 = value) instanceof String) {
                event.getStringParams().put((String)key, (String)value);
                continue;
            }
            if (object2 instanceof Integer) {
                event.getIntegerParams().put((String)key, (Integer)value);
                continue;
            }
            if (object2 instanceof Boolean) {
                event.getBooleanParams().put((String)key, (Boolean)value);
                continue;
            }
            if (!(object2 instanceof Date)) continue;
            event.getDateParams().put((String)key, (int)(((Date)value).getTime() / (long)1000));
        }
        return event;
    }

    public static /* synthetic */ Event prepareEvent$push_release$default(RedlinkAnalytics redlinkAnalytics, String string, Map map, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return redlinkAnalytics.prepareEvent$push_release(string, map, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUserDataValid(String userDataJson) {
        if (userDataJson == null) return true;
        Boolean bl = StringKt.isJson(userDataJson);
        if (bl == null) return false;
        boolean bl2 = bl;
        if (!bl2) return false;
        return true;
    }

    private final boolean isEventNameValid(String name) {
        return !StringsKt.contains$default((CharSequence)name, (CharSequence)CHAR_SPACE, (boolean)false, (int)2, null) && name.length() <= 64;
    }

    private final boolean areParamsValid(Map<String, ? extends Object> params) {
        boolean isValid = true;
        Map<String, ? extends Object> $this$forEach$iv = params;
        boolean $i$f$forEach = false;
        Map<String, ? extends Object> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> it = element$iv = iterator.next();
            boolean bl2 = false;
            if (it.getKey().length() <= 64) continue;
            Logger.INSTANCE.error("Invalid event param key -> " + it.getKey() + " (Key names can be up to 64 long");
            if (isValid) {
                // empty if block
            }
            isValid = false;
        }
        return isValid;
    }

    private RedlinkAnalytics() {
    }

    static {
        RedlinkAnalytics redlinkAnalytics;
        INSTANCE = redlinkAnalytics = new RedlinkAnalytics();
    }
}

