package pl.redlink.push.service.model

import org.json.JSONException
import org.json.JSONObject

internal data class Status(
        val id: String,
        val status: ReportPushStatus,
        val type: Device.Type,
        val registrationId: String,
        val occurredAt: Long,
        val actionId: String? = null,
        val details: String? = null
) {

    internal fun toJson(): String? =
            try {
                JSONObject().apply {
                    put(JSON_KEY_STATUS, status.value)
                    put(JSON_KEY_REGISTRATION_ID, registrationId)
                    put(JSON_KEY_OCCURRED_AT, occurredAt)
                    put(JSON_KEY_TYPE, type.value)
                    put(JSON_KEY_DETAILS, details)
                    put(JSON_ACTION_ID, actionId)
                }.toString()
            } catch (e: JSONException) {
                null
            }

    enum class ReportPushStatus(val value: String) {
        RECEIVED("RECEIVED"),
        REACTED_ON("REACTED_ON")
    }

    companion object {
        private const val JSON_KEY_STATUS = "status"
        private const val JSON_KEY_TYPE = "type"
        private const val JSON_KEY_REGISTRATION_ID = "registration_id"
        private const val JSON_KEY_OCCURRED_AT = "occurred_at"
        private const val JSON_ACTION_ID = "action_id"
        private const val JSON_KEY_DETAILS = "details"
    }

}

