package pl.redlink.push.fcm

import android.os.Parcelable
import pl.redlink.push.extension.createJsonObjectOrNull
import pl.redlink.push.extension.getStringOrNull
import pl.redlink.push.fcm.action.Action
import pl.redlink.push.fcm.action.ActionButtons
import pl.redlink.push.fcm.action.KEY_ACTION
import pl.redlink.push.service.model.KeyValue
import kotlinx.android.parcel.IgnoredOnParcel
import kotlinx.android.parcel.Parcelize

const val KEY_ID = "id"
const val KEY_TITLE = "title"
const val KEY_BODY = "body"
const val KEY_ACTION_BUTTONS = "action_buttons"
const val KEY_SILENT = "silent"
const val KEY_SOUND = "sound"
const val KEY_IMAGE = "image"
const val KET_TTL = "ttl"
const val KEY_FORCE_VISIBILITY_TIL = "force_visibility_until"
const val KEY_SMALL_ICON = "small_icon"
const val KEY_LOCK_SCREEN_VISIBILITY = "lockscreen_visibility"
const val KEY_LARGE_ICON = "large_icon"
const val KEY_EXPAND_TEXT = "expanded_text"
const val KEY_CUSTOM_DATA = "custom_data"
const val KEY_ANDROID = "android"

@Parcelize
data class PushMessage internal constructor(val data: Map<String, String>) : Parcelable {

    @IgnoredOnParcel
    private val androidObject = createJsonObjectOrNull(data[KEY_ANDROID])

    val id: String?
        get() = data[KEY_ID]

    val title: String?
        get() = data[KEY_TITLE]

    val body: String?
        get() = data[KEY_BODY]

    val action: Action?
        get() = Action.fromJson(data[KEY_ACTION])

    val sound: String?
        get() = data[KEY_SOUND]

    val image: String?
        get() = data[KEY_IMAGE]

    val expandText: String?
        get() {
            return androidObject?.getStringOrNull(KEY_EXPAND_TEXT)
        }

    val largeIcon: String?
        get() {
            val android = createJsonObjectOrNull(data[KEY_ANDROID])
            return android?.getStringOrNull(KEY_LARGE_ICON)
        }

    val smallIcon: String?
        get() {
            return androidObject?.getStringOrNull(KEY_SMALL_ICON)
        }

    val silent: Boolean?
        get() = data[KEY_SILENT]?.toBoolean()

    val forceVisibilityTil: Long?
        get() = data[KEY_FORCE_VISIBILITY_TIL]?.toLong()

    val lockScreenVisibility: String?
        get() = androidObject?.getStringOrNull(KEY_LOCK_SCREEN_VISIBILITY)

    val actions: ActionButtons?
        get() {
            val actionButton = data[KEY_ACTION_BUTTONS]
            return ActionButtons.fromJson(actionButton)
        }

    val customData: List<KeyValue>?
        get() = KeyValue.fromJson(data[KEY_CUSTOM_DATA])

    fun has(key: String) = data.containsKey(key)

}