package pl.redlink.push.service.model

import org.json.JSONException
import org.json.JSONObject
import pl.redlink.push.manager.user.RedlinkUser

internal class User {

    val userProfile: Map<String, String>
        get() = RedlinkUser.get()?.redlinkValues.orEmpty()

    val custom = CustomData().apply {
        stringFields = RedlinkUser.get()?.customStringValues ?: mutableMapOf()
        integerFields = RedlinkUser.get()?.customIntValues ?: mutableMapOf()
        booleanFields = RedlinkUser.get()?.customBooleanValues ?: mutableMapOf()
        dateFields = RedlinkUser.get()?.customDateValues ?: mutableMapOf()
    }

    internal fun toJson(): String? =
        try {
            JSONObject().apply {
                put(JSON_KEY_USER_PROFILE, JSONObject(userProfile))
                put(JSON_KEY_CUSTOM, custom.toJsonObject())
            }.toString()
        } catch (e: JSONException) {
            null
        }

    companion object {
        private const val JSON_KEY_USER_PROFILE = "user_profile"
        private const val JSON_KEY_CUSTOM = "custom"
    }

}