package pl.redlink.push.service.model

import android.os.Build
import pl.redlink.push.manager.user.RedlinkUser
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.util.*

internal data class Device(
        var registrationId: String,
        var oldRegistrationId: String? = null,
        var appId: String?,
        val type: Type = Type.ANDROID,
        var userId: String?,
        val mobileAgent: Map<String, String> = mapOf(
                "language" to Locale.getDefault().language,
                "system_name" to Type.ANDROID.value,
                "system_version" to Build.VERSION.SDK_INT.toString(),
                "phone_model" to Build.MODEL
        )
) {

    internal fun toJson(): String? =
            try {
                JSONObject().apply {
                    put(JSON_KEY_REGISTRATION_ID, registrationId)
                    put(JSON_KEY_OLD_REGISTRATION_ID, oldRegistrationId)
                    put(JSON_KEY_APP_ID, appId)
                    put(JSON_KEY_TYPE, type.value)
                    put(JSON_KEY_USER_ID, userId)
                    put(JSON_MOBILE_AGENT, JSONArray().apply { put(JSONObject(mobileAgent)) })
                }.toString()
            } catch (e: JSONException) {
                null
            }

    companion object {
        private const val JSON_KEY_USER_ID = "user_id"
        private const val JSON_KEY_TYPE = "type"
        private const val JSON_KEY_REGISTRATION_ID = "registration_id"
        private const val JSON_KEY_OLD_REGISTRATION_ID = "old_registration_id"
        private const val JSON_KEY_APP_ID = "app_id"
        private const val JSON_MOBILE_AGENT = "mobile_agent"
    }

    enum class Type(val value: String) {

        ANDROID("ANDROID"),
        IOS("IOS")

    }

}
