package pl.redlink.push.provider

import android.annotation.SuppressLint
import android.content.Context
import pl.redlink.push.extension.getStringResourceByName

@SuppressLint("StaticFieldLeak")
object RedlinkIdProvider {

    private const val REDLINK_APP_ID_KEY = "redlink_app_id"
    private const val FCM_PROJECT_ID_KEY = "fcm_sender_id"
    private const val REDLINK_TOKEN_KEY = "redlink_token"
    private const val REDLINK_SECRET_KEY = "redlink_secret"
    private const val REDLINK_EVENT_KEY = "redlink_events_token"

    internal var context: Context? = null

    fun getRedlinkAppId(): String? =
            context?.getStringResourceByName(REDLINK_APP_ID_KEY)

    fun getRedlinkToken(): String? =
            context?.getStringResourceByName(REDLINK_TOKEN_KEY)

    fun getRedlinkSecret(): String? =
            context?.getStringResourceByName(REDLINK_SECRET_KEY)

    fun getRedlinkEventsToken(): String? =
        context?.getStringResourceByName(REDLINK_EVENT_KEY)

    fun getFcmProjectId(): String? =
            context?.getStringResourceByName(FCM_PROJECT_ID_KEY)

}
