package pl.redlink.push.manager.token

import android.annotation.SuppressLint
import android.content.Context
import pl.redlink.push.manager.PREFS_KEY_FCM_TOKEN
import pl.redlink.push.manager.PREFS_NAME

@SuppressLint("StaticFieldLeak")

object FcmTokenManager {

    private var context: Context? = null
    private var prefs = lazy { context?.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE) }

    @JvmSynthetic
    internal fun init(context: Context) {
        this.context = context
    }

    @JvmSynthetic
    internal fun put(fcmToken: String) {
        if (fcmToken != get()) {
            prefs.value?.edit()?.putString(PREFS_KEY_FCM_TOKEN, fcmToken)?.apply()
        }
    }

    fun get(): String? = prefs.value?.getString(PREFS_KEY_FCM_TOKEN, "")


    @JvmSynthetic
    internal fun remove() {
        prefs.value?.edit()?.remove(PREFS_KEY_FCM_TOKEN)?.apply()
    }

    @JvmSynthetic
    internal fun isNewToken(token: String?): Boolean = token != get()

}
