package pl.redlink.push.fcm.notification.extender

import androidx.core.app.NotificationCompat
import pl.redlink.push.fcm.PushMessage

internal class TextExtender(private val pushMessage: PushMessage) : NotificationCompat.Extender {

    override fun extend(builder: NotificationCompat.Builder): NotificationCompat.Builder {
        pushMessage.expandText?.also {
            builder.setStyle(NotificationCompat.BigTextStyle().bigText(it))
        }
        return builder
    }

}
