package pl.redlink.push.fcm.notification.extender

import android.content.Context
import androidx.core.app.NotificationCompat
import pl.redlink.push.R
import pl.redlink.push.extension.getDrawableResourceIdByName
import pl.redlink.push.fcm.KEY_ACTION_BUTTONS
import pl.redlink.push.fcm.NotificationActionBroadcast
import pl.redlink.push.fcm.PushMessage
import java.security.SecureRandom

internal class ActionsExtender(private val context: Context, private val notificationId: Int, private val pushMessage: PushMessage) : NotificationCompat.Extender {

    override fun extend(builder: NotificationCompat.Builder): NotificationCompat.Builder {
        if (pushMessage.has(KEY_ACTION_BUTTONS)) {
            pushMessage.actions?.actionButton?.filter { !it.text.isNullOrBlank() }?.map { actionButton ->
                actionButton.action?.let { action ->
                    val random = SecureRandom()
                    val iconRes = actionButton.icon?.let { context.getDrawableResourceIdByName(it) }
                    val icon = iconRes ?: R.drawable.redlink_default_icon
                    builder.addAction(
                            icon,
                            actionButton.text,
                            NotificationActionBroadcast.getActionPendingIntent(context, pushMessage, action, notificationId, random.nextInt())
                    )
                }
            }
        }
        return builder
    }

}