package pl.redlink.push.fcm.action

import android.os.Parcelable
import pl.redlink.push.extension.getJSONObjectOrNull
import pl.redlink.push.extension.getStringOrNull
import pl.redlink.push.extension.mapNotNull
import pl.redlink.push.extension.toEnumOrDefault
import kotlinx.android.parcel.Parcelize
import org.json.JSONObject

const val KEY_URL = "url"
const val KEY_TYPE = "type"
const val KEY_ICON = "icon"
const val KEY_TEXT = "text"
const val KEY_ACTION = "action"
const val KEY_ITEMS = "items"
const val KEY_CATEGORY_ID = "category_id"
const val KEY_ID = "id"

@Parcelize
data class ActionButtons(val categoryId: String?, val actionButton: List<ActionButton>) : Parcelable {

    companion object {

        fun fromJson(json: String?): ActionButtons? {
            return json?.let { fromJson(JSONObject(json)) }
        }

        fun fromJson(jsonObject: JSONObject): ActionButtons? {
            return takeIf { (jsonObject.has(KEY_ITEMS)) }?.let {
                val categoryId = jsonObject.getStringOrNull(KEY_CATEGORY_ID)
                val itemArray = jsonObject.getJSONArray(KEY_ITEMS)
                val items = itemArray.mapNotNull<JSONObject, ActionButton?> { ActionButton.fromJson(it) }
                        .asSequence().filterNotNull().toList()
                return ActionButtons(categoryId, items)
            }
        }

    }

}

@Parcelize
data class ActionButton(val text: String?, val icon: String?, val action: Action?) : Parcelable {

    companion object {
        fun fromJson(jsonObject: JSONObject): ActionButton? {
            val text = jsonObject.getStringOrNull(KEY_TEXT)
            val icon = jsonObject.getStringOrNull(KEY_ICON)
            val action = jsonObject.getJSONObjectOrNull(KEY_ACTION)?.let { Action.fromJson(it) }
            return ActionButton(text, icon, action)
        }
    }

}

@Parcelize
data class Action(val id: String? = null, val url: String?, val type: ActionType) : Parcelable {

    companion object {

        fun fromJson(jsonObject: JSONObject): Action? {
            val url = jsonObject.getStringOrNull(KEY_URL)
            val type = jsonObject.getStringOrNull(KEY_TYPE)
            val id = jsonObject.getStringOrNull(KEY_ID)
            return Action(id, url, toEnumOrDefault(ActionType::class.java, type, ActionType.NONE))

        }

        fun fromJson(json: String?): Action? {
            return json?.let { fromJson(JSONObject(it)) }
        }

    }

}