package pl.redlink.push.di

import pl.redlink.push.fcm.CustomTabProvider
import pl.redlink.push.fcm.RedlinkActionHandler
import pl.redlink.push.fcm.action.ActionProcessor
import pl.redlink.push.fcm.action.DefaultActionHandler
import pl.redlink.push.http.HttpClient
import pl.redlink.push.http.RestClient
import pl.redlink.push.lifecycle.ActivityLifecycleHandler
import pl.redlink.push.lifecycle.AppLifecycleDelegate
import pl.redlink.push.lifecycle.AppLifecycleDelegateHandler
import pl.redlink.push.lifecycle.LifecycleController
import pl.redlink.push.service.repository.ApiRepository
import pl.redlink.push.service.repository.ApiRepositoryImpl
import pl.redlink.push.service.repository.PushRepository
import pl.redlink.push.service.repository.PushRepositoryImpl
import pl.redlink.push.ui.InAppPushManager

internal fun redlink(): RedlinkComponent = RedlinkModule

internal interface RedlinkComponent {

    val httpClient: HttpClient
    val restClient: RestClient

    val customTabProvider: CustomTabProvider
    val lifecycleDelegate: AppLifecycleDelegate
    val activityLifeCycleHandler: ActivityLifecycleHandler
    val lifecycleController: LifecycleController
    val actionProcessor: ActionProcessor
    val pushRepository: PushRepository
    val apiRepository: ApiRepository
    val inAppPushManagerManager: InAppPushManager
    var redlinkActionHandler: RedlinkActionHandler

}

internal object RedlinkModule : RedlinkComponent {

    override val httpClient = HttpClient()

    override val restClient = RestClient(httpClient)

    override val customTabProvider = CustomTabProvider()

    override val pushRepository: PushRepository = PushRepositoryImpl(restClient)

    override val apiRepository: ApiRepository = ApiRepositoryImpl(restClient)

    override val actionProcessor: ActionProcessor = ActionProcessor(customTabProvider)

    override val inAppPushManagerManager: InAppPushManager = InAppPushManager()

    override val lifecycleDelegate = AppLifecycleDelegateHandler(inAppPushManagerManager)

    override val activityLifeCycleHandler = ActivityLifecycleHandler(lifecycleDelegate)

    override val lifecycleController: LifecycleController = LifecycleController()

    override var redlinkActionHandler: RedlinkActionHandler = DefaultActionHandler()

}
