/*
 * Decompiled with CFR 0.152.
 */
package pl.redlink.push.provider;

import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.redlink.push.Logger;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lpl/redlink/push/provider/FirebaseTokenProvider;", "", "()V", "getFcmToken", "", "fcmProjectId", "push_release"})
public final class FirebaseTokenProvider {
    public static final FirebaseTokenProvider INSTANCE;

    @Nullable
    public final String getFcmToken(@NotNull String fcmProjectId2) {
        Intrinsics.checkParameterIsNotNull((Object)fcmProjectId2, (String)"fcmProjectId");
        try {
            FirebaseApp app = FirebaseApp.getInstance();
            if (app != null) {
                FirebaseInstanceId instanceId = FirebaseInstanceId.getInstance((FirebaseApp)app);
                String token = instanceId.getToken(fcmProjectId2, "FCM");
                CharSequence charSequence = token;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    Logger.INSTANCE.info("FCM token: " + token);
                    return token;
                }
                Logger.INSTANCE.error("Token cannot be fetched");
            } else {
                Logger.INSTANCE.error("Firebase instance not been initialized");
            }
        }
        catch (IllegalStateException exception) {
            Logger.INSTANCE.error("Firebase has not been initialized - use official docs to configure -> https://firebase.google.com/docs/android/setup");
        }
        catch (IOException exception) {
            Logger.INSTANCE.error("Token cannot be fetched due to failed or interrupted I/O operation");
        }
        return null;
    }

    private FirebaseTokenProvider() {
    }

    static {
        FirebaseTokenProvider firebaseTokenProvider;
        INSTANCE = firebaseTokenProvider = new FirebaseTokenProvider();
    }
}

