/*
 * Decompiled with CFR 0.152.
 */
package pl.redlink.push.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.redlink.push.di.RedlinkComponentKt;
import pl.redlink.push.fcm.action.Action;
import pl.redlink.push.fcm.action.ActionProcessor;
import pl.redlink.push.fcm.action.ActionType;
import pl.redlink.push.lifecycle.AppLifecycleDelegate;
import pl.redlink.push.lifecycle.RedlinkLifecycle;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0019\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u0015\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u0016\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u001b\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\fH\u0016J\u001a\u0010\u001f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lpl/redlink/push/lifecycle/ActivityLifecycleHandler;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "Landroid/content/ComponentCallbacks2;", "Lpl/redlink/push/lifecycle/RedlinkLifecycle;", "lifecycleDelegate", "Lpl/redlink/push/lifecycle/AppLifecycleDelegate;", "actionProcessor", "Lpl/redlink/push/fcm/action/ActionProcessor;", "(Lpl/redlink/push/lifecycle/AppLifecycleDelegate;Lpl/redlink/push/fcm/action/ActionProcessor;)V", "isAppInForeground", "", "handleIntent", "", "activity", "Landroid/app/Activity;", "intent", "Landroid/content/Intent;", "onActivityCreated", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onLowMemory", "onNewIntent", "onTrimMemory", "level", "", "push_release"})
public final class ActivityLifecycleHandler
implements Application.ActivityLifecycleCallbacks,
ComponentCallbacks2,
RedlinkLifecycle {
    private boolean isAppInForeground;
    private final AppLifecycleDelegate lifecycleDelegate;
    private final ActionProcessor actionProcessor;

    public void onActivityResumed(@Nullable Activity activity) {
        if (!this.isAppInForeground) {
            this.isAppInForeground = true;
            this.lifecycleDelegate.onAppInForeground((Context)activity);
        }
    }

    public void onTrimMemory(int level) {
        if (level == 20) {
            this.isAppInForeground = false;
            this.lifecycleDelegate.onAppInBackground();
        }
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        if (savedInstanceState == null) {
            this.handleIntent(activity, activity.getIntent());
        }
    }

    public void onLowMemory() {
    }

    public void onConfigurationChanged(@Nullable Configuration newConfig) {
    }

    public void onActivityPaused(@Nullable Activity activity) {
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @Nullable Bundle outState) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
    }

    @Override
    public void onNewIntent(@NotNull Activity activity, @Nullable Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        this.handleIntent(activity, intent);
    }

    private final void handleIntent(Activity activity, Intent intent) {
        Intent intent2 = intent;
        if (intent2 != null) {
            if (intent2.hasExtra("pl.redlink.push.fcm.extra-action")) {
                Action action = (Action)intent.getParcelableExtra("pl.redlink.push.fcm.extra-action");
                intent.removeExtra("pl.redlink.push.fcm.extra-action");
                if (action.getType() == ActionType.WEBVIEW) {
                    Context context = (Context)activity;
                    Action action2 = action;
                    Intrinsics.checkExpressionValueIsNotNull((Object)action2, (String)"action");
                    this.actionProcessor.runWebview(context, action2);
                }
            }
        }
    }

    public ActivityLifecycleHandler(@NotNull AppLifecycleDelegate lifecycleDelegate, @NotNull ActionProcessor actionProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)lifecycleDelegate, (String)"lifecycleDelegate");
        Intrinsics.checkParameterIsNotNull((Object)actionProcessor, (String)"actionProcessor");
        this.lifecycleDelegate = lifecycleDelegate;
        this.actionProcessor = actionProcessor;
    }

    public /* synthetic */ ActivityLifecycleHandler(AppLifecycleDelegate appLifecycleDelegate, ActionProcessor actionProcessor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            appLifecycleDelegate = RedlinkComponentKt.redlink().getLifecycleDelegate();
        }
        if ((n & 2) != 0) {
            actionProcessor = RedlinkComponentKt.redlink().getActionProcessor();
        }
        this(appLifecycleDelegate, actionProcessor);
    }

    public ActivityLifecycleHandler() {
        this(null, null, 3, null);
    }
}

