package pl.redlink.push.service

import android.content.Context
import android.content.Intent
import androidx.core.app.JobIntentService
import pl.redlink.push.Logger
import pl.redlink.push.di.RedlinkModule.pushRepository
import pl.redlink.push.manager.token.FcmTokenManager
import pl.redlink.push.provider.FirebaseTokenProvider
import pl.redlink.push.provider.RedlinkIdProvider
import pl.redlink.push.provider.UuidProvider
import pl.redlink.push.service.model.Device
import kotlinx.coroutines.runBlocking

class RegisterDeviceService : JobIntentService() {

    override fun onHandleWork(intent: Intent) {
        val force = intent.getBooleanExtra(EXTRA_FORCE, false)
        runBlocking {
            RedlinkIdProvider.getFcmProjectId()?.let { fcmProjectId ->
                val redlinkAppId = RedlinkIdProvider.getRedlinkAppId()
                val fcmToken = FirebaseTokenProvider.getFcmToken(fcmProjectId)
                val savedFcmToken = FcmTokenManager.get()
                if (fcmToken != null && (FcmTokenManager.isNewToken(fcmToken) || force)) {
                    val response = pushRepository.registerDevice(Device(
                            registrationId = fcmToken,
                            appId = redlinkAppId,
                            userId = UuidProvider.provideUuid(applicationContext)
                    ).also {
                        if (!savedFcmToken.isNullOrEmpty() && fcmToken != savedFcmToken) {
                            it.oldRegistrationId = savedFcmToken
                        }
                    })
                    if (response.isSuccess()) {
                        FcmTokenManager.put(fcmToken)
                    } else {
                        Logger.error("Device cannot be registered, please check your connection and credential keys")
                    }
                }
            }
        }
    }

    companion object {

        private const val REGISTER_DEVICE_JOB_ID = 2000
        private const val EXTRA_FORCE = "pl.redlink.push.service.EXTRA-FORCE"

        fun enqueueRequest(context: Context, force: Boolean = false) {
            val intent = Intent(context, RegisterDeviceService::class.java)
            intent.putExtra(EXTRA_FORCE, force)
            enqueueWork(context, RegisterDeviceService::class.java, REGISTER_DEVICE_JOB_ID, intent)
        }

    }

}