package pl.redlink.push.provider

import com.google.firebase.FirebaseApp
import com.google.firebase.iid.FirebaseInstanceId
import com.google.firebase.messaging.FirebaseMessaging
import pl.redlink.push.Logger
import java.io.IOException

object FirebaseTokenProvider {

    fun getFcmToken(fcmProjectId: String): String? {
        try {
            val app = FirebaseApp.getInstance()
            if (app != null) {
                val instanceId = FirebaseInstanceId.getInstance(app)
                val token = instanceId.getToken(fcmProjectId, FirebaseMessaging.INSTANCE_ID_SCOPE)
                if (!token.isNullOrEmpty()) {
                    Logger.info("FCM token: $token")
                    return token
                } else {
                    Logger.error("Token cannot be fetched")
                }
            } else {
                Logger.error("Firebase instance not been initialized")
            }
        } catch (exception: IllegalStateException) {
            Logger.error("Firebase has not been initialized - use official docs to configure -> https://firebase.google.com/docs/android/setup")
        } catch (exception: IOException) {
            Logger.error("Token cannot be fetched due to failed or interrupted I/O operation")
        }
        return null
    }

}
