package pl.redlink.push.media

import android.graphics.Bitmap
import android.graphics.BitmapFactory
import pl.redlink.push.Logger
import java.io.IOException
import java.net.HttpURLConnection
import java.net.URL

fun getIcon(url: String): Bitmap? {
    try {
        (URL(url).openConnection() as? HttpURLConnection)?.apply {
            doInput = true
            connect()
            return BitmapFactory.decodeStream(inputStream)
        }
    } catch (e: IOException) {
        pl.redlink.push.Logger.stackTrace(e)
    }
    return null
}
