package pl.redlink.push.manager.user

import android.annotation.SuppressLint
import android.content.Context
import pl.redlink.push.manager.PREFS_KEY_USER
import pl.redlink.push.manager.PREFS_NAME
import pl.redlink.push.manager.PreferencesManager
import pl.redlink.push.service.RegisterDeviceService
import java.util.*

@SuppressLint("StaticFieldLeak")
object RedlinkUser {

    private var context: Context? = null

    private fun put(user: RedlinkUserData) {
        user.toJsonString()?.also {
            remove()
            PreferencesManager.put(PREFS_KEY_USER, it)
        }
    }

    @JvmSynthetic
    fun init(context: Context) {
        this.context = context
    }

    @JvmStatic fun get(): RedlinkUserData? =
            RedlinkUserData.fromJson(PreferencesManager.get(PREFS_KEY_USER) ?: "")
                    ?: RedlinkUserData()

    @JvmStatic fun remove() {
        PreferencesManager.remove(PREFS_KEY_USER)
    }

    class Edit {

        private val user: RedlinkUserData = get() ?: RedlinkUserData()

        fun email(email: String): Edit {
            user.email = email
            return this
        }

        fun phone(phone: String): Edit {
            user.phone = phone
            return this
        }

        fun firstName(firstName: String): Edit {
            user.firstName = firstName
            return this
        }

        fun lastName(lastName: String): Edit {
            user.lastName = lastName
            return this
        }

        fun companyName(companyName: String): Edit {
            user.companyName = companyName
            return this
        }

        fun customValue(key: String, value: String): Edit {
            user.customStringValues[key] = value
            return this
        }

        fun customValue(key: String, value: Int): Edit {
            user.customIntValues[key] = value
            return this
        }

        fun customValue(key: String, value: Boolean): Edit {
            user.customBooleanValues[key] = value
            return this
        }

        fun customValue(key: String, value: Date): Edit {
            user.customDateValues[key] = (value.time / 1000).toInt()
            return this
        }

        fun removeCustomValues(): Edit {
            user.customStringValues.clear()
            user.customIntValues.clear()
            user.customBooleanValues.clear()
            user.customDateValues.clear()
            return this
        }

        fun save() {
            RedlinkUser.put(user)
            context?.let { RegisterDeviceService.enqueueRequest(it, true) }
        }

    }

}
