package pl.redlink.push.manager

import android.annotation.SuppressLint
import android.content.Context
import pl.redlink.push.RedlinkApp

@SuppressLint("StaticFieldLeak")
object PreferencesManager {

    private var context: Context? = null

    fun init(context: Context) {
        this.context = context
    }

    private var prefs = lazy { context?.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE) }

    fun put(key: String, value: String) = prefs.value?.edit()?.putString(key, value)?.apply()

    fun get(key: String): String? = prefs.value?.getString(key, "")

    fun remove(key: String) = prefs.value?.edit()?.remove(key)?.apply()
    
}