package pl.redlink.push.http.interceptor

import pl.redlink.push.http.Request
import pl.redlink.push.http.Response
import org.json.JSONObject
import pl.redlink.push.Logger

val loggerInterceptor: (Request, Response) -> Unit = { request, response ->
    Logger.apply {
        info("- - - - - - - - - - - - -")
        info("Request")
        info("Headers" + request.headers.toString())
        try {
            info("Body: " + JSONObject(request.body.toString()).toString(3))
        } catch (e: Exception) {
            info("Body: " + request.body.toString())
        }
        info("- - - - - - - - - - - - -")
        info("Response")
        info("HTTP Status code: ${response.status} | ${response.url}")
        info("Body:")
        info(response.body ?: "")
        info("- - - - - - - - - - - - -")
    }
}
