package pl.redlink.push.fcm.notification.extender

import android.content.Context
import android.media.RingtoneManager
import androidx.core.app.NotificationCompat
import pl.redlink.push.extension.getRawResourceUriByName
import pl.redlink.push.fcm.PushMessage

internal class SoundExtender(private val context: Context, private val pushMessage: PushMessage) : NotificationCompat.Extender {

    override fun extend(builder: NotificationCompat.Builder): NotificationCompat.Builder {
        pushMessage.sound?.also { string ->
            builder.setSound(context.getRawResourceUriByName(string)
                    ?: RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION))
        } ?: builder.setSound(RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION))
        return builder
    }

}
