package pl.redlink.push.fcm

import android.content.Intent
import pl.redlink.push.fcm.notification.RedlinkNotification
import pl.redlink.push.service.RegisterDeviceService
import com.google.firebase.messaging.FirebaseMessagingService
import com.google.firebase.messaging.RemoteMessage

class RedlinkFirebaseMessagingService : FirebaseMessagingService(), PushReceiver {

    override fun onNewToken(token: String?) {
        super.onNewToken(token)
        RegisterDeviceService.enqueueRequest(applicationContext)
    }

    override fun onMessageReceived(message: RemoteMessage?) {
        super.onMessageReceived(message)
        RedlinkNotification.providePushMessage(message)?.let {
            onPushMessageReceived(it)
            sendBroadcast(it)
        }
    }

    /**
     * Method will be called when received push is from redlink
     */
    override fun onPushMessageReceived(pushMessage: PushMessage) {
        RedlinkNotification.handlePushMessage(applicationContext, pushMessage)
    }

    private fun sendBroadcast(pushMessage: PushMessage) {
        Intent().apply {
            action = PUSH_ACTION
            putExtra(EXTRA_PUSH_MESSAGE, pushMessage)
            sendBroadcast(this)
        }
    }

    companion object {
        const val PUSH_ACTION = "pl.redlink.push.fcm.PUSH_ACTION"
        const val EXTRA_PUSH_MESSAGE = "pl.redlink.push.fcm.EXTRA_PUSH_MESSAGE"
    }

}