package pl.redlink.push.database

import android.provider.BaseColumns

internal object EventsDatabaseTable {

    const val TABLE_NAME = "events"
    const val COLUMN_NAME_ID = BaseColumns._ID
    const val COLUMN_NAME_NAME = "name"
    const val COLUMN_NAME_TIMESTAMP = "timestamp"
    const val COLUMN_NAME_STRING_PARAMETERS = "stringParameters"
    const val COLUMN_NAME_BOOLEAN_PARAMETERS = "booleanParameters"
    const val COLUMN_NAME_INTEGER_PARAMETERS = "integerParameters"
    const val COLUMN_NAME_DATE_PARAMETERS = "dateParameters"

    const val QUERY_CREATE_TABLE =
            "CREATE TABLE IF NOT EXISTS ${pl.redlink.push.database.EventsDatabaseTable.TABLE_NAME} (" +
                    "${pl.redlink.push.database.EventsDatabaseTable.COLUMN_NAME_ID} INTEGER PRIMARY KEY," +
                    "${pl.redlink.push.database.EventsDatabaseTable.COLUMN_NAME_NAME} TEXT," +
                    "${pl.redlink.push.database.EventsDatabaseTable.COLUMN_NAME_TIMESTAMP} REAL," +
                    "${pl.redlink.push.database.EventsDatabaseTable.COLUMN_NAME_STRING_PARAMETERS} BLOB, " +
                    "${pl.redlink.push.database.EventsDatabaseTable.COLUMN_NAME_BOOLEAN_PARAMETERS} BLOB, " +
                    "${pl.redlink.push.database.EventsDatabaseTable.COLUMN_NAME_INTEGER_PARAMETERS} BLOB, " +
                    "${pl.redlink.push.database.EventsDatabaseTable.COLUMN_NAME_DATE_PARAMETERS} BLOB)"

    const val QUERY_DROP_TABLE =
            "DROP TABLE IF EXISTS ${pl.redlink.push.database.EventsDatabaseTable.TABLE_NAME}"

    const val QUERY_CLEAR_TABLE =
            "DELETE FROM ${pl.redlink.push.database.EventsDatabaseTable.TABLE_NAME}"

}
