package pl.redlink.push.database

import android.os.Parcelable
import kotlinx.android.parcel.Parcelize

@Parcelize
internal data class Event(
    val id: Int = UNDEFINED,
    val name: String,
    val timestamp: Long,
    val booleanParams: MutableMap<String, Boolean> = mutableMapOf(),
    val stringParams: MutableMap<String, String> = mutableMapOf(),
    val integerParams: MutableMap<String, Int> = mutableMapOf(),
    val dateParams: MutableMap<String, Int> = mutableMapOf()
) : Parcelable {

    companion object {
        const val UNDEFINED = -1
    }

}
