/*
 * Decompiled with CFR 0.152.
 */
package pl.rafman.scrollcalendar.data;

import androidx.annotation.NonNull;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import pl.rafman.scrollcalendar.data.CalendarDay;

public class CalendarMonth
implements Serializable {
    private final String[] months = new DateFormatSymbols().getMonths();
    private final int year;
    private final int month;
    @NonNull
    private final CalendarDay[] days;

    public CalendarMonth(int year, int month) {
        this(year, month, CalendarMonth.makeDays(year, month));
    }

    private CalendarMonth(int year, int month, @NonNull CalendarDay[] days) {
        this.year = year;
        this.month = month;
        this.days = days;
    }

    @NonNull
    static CalendarDay[] makeDays(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        int maxDays = calendar.getActualMaximum(5);
        CalendarDay[] calendarDays = new CalendarDay[maxDays];
        for (int i = 1; i <= maxDays; ++i) {
            calendarDays[i - 1] = new CalendarDay(i);
        }
        return calendarDays;
    }

    @NonNull
    public CalendarDay[] getDays() {
        return this.days;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public CalendarMonth previous() {
        if (this.month == 0) {
            return new CalendarMonth(this.year - 1, 11);
        }
        return new CalendarMonth(this.year, this.month - 1);
    }

    public CalendarMonth next() {
        if (this.month == 11) {
            return new CalendarMonth(this.year + 1, 0);
        }
        return new CalendarMonth(this.year, this.month + 1);
    }

    public static CalendarMonth now() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2);
        return new CalendarMonth(year, month);
    }

    @NonNull
    public String getReadableMonthName() {
        return this.getMonthForInt(this.getMonth()) + this.maybeGetYear();
    }

    private String maybeGetYear() {
        if (this.isaCurrentYear()) {
            return "";
        }
        return " " + this.year;
    }

    private boolean isaCurrentYear() {
        return this.year == Calendar.getInstance().get(1);
    }

    private String getMonthForInt(int num) {
        if (num < 0) {
            return "";
        }
        if (num >= this.months.length) {
            return "";
        }
        return this.months[num];
    }

    @NonNull
    public String getMonthNameWithYear() {
        return this.getMonthForInt(this.getMonth()) + " " + this.year;
    }
}

