/*
 * Decompiled with CFR 0.152.
 */
package pl.rafman.scrollcalendar;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Calendar;
import pl.rafman.scrollcalendar.CalendarProvider;
import pl.rafman.scrollcalendar.LegendItem;
import pl.rafman.scrollcalendar.R;
import pl.rafman.scrollcalendar.adapter.ResProvider;
import pl.rafman.scrollcalendar.adapter.ScrollCalendarAdapter;
import pl.rafman.scrollcalendar.adapter.example.DefaultDateScrollCalendarAdapter;
import pl.rafman.scrollcalendar.adapter.example.DefaultRangeScrollCalendarAdapter;
import pl.rafman.scrollcalendar.contract.DateWatcher;
import pl.rafman.scrollcalendar.contract.MonthScrollListener;
import pl.rafman.scrollcalendar.contract.OnDateClickListener;
import pl.rafman.scrollcalendar.style.DayResProviderImpl;
import pl.rafman.scrollcalendar.style.MonthResProviderImpl;
import pl.rafman.scrollcalendar.values.Keys;

public class ScrollCalendar
extends LinearLayoutCompat
implements ResProvider,
CalendarProvider {
    @Nullable
    private String customFont;
    @Nullable
    private ScrollCalendarAdapter adapter;
    @StyleRes
    private int monthTitleStyle;
    @StyleRes
    private int legendItemStyle;
    @StyleRes
    private int legendSeparatorStyle;
    @StyleRes
    private int currentDayStyle;
    @StyleRes
    private int selectedItemStyle;
    @StyleRes
    private int selectedBeginningDayStyle;
    @StyleRes
    private int selectedMiddleDayStyle;
    @StyleRes
    private int selectedEndDayStyle;
    @StyleRes
    private int disabledItemStyle;
    @StyleRes
    private int unavailableItemStyle;
    @StyleRes
    private int dayStyle;
    private int defaultAdapter;
    private int firstDayOfWeek;
    private boolean showYearAlways;
    private boolean softLineBreaks;
    private final LegendItem[] legend = new LegendItem[7];
    private static final int[] attrs = new int[]{16842964, 0x1010155};

    public ScrollCalendar(Context context) {
        super(context);
        this.init(context);
    }

    public ScrollCalendar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initStyle(context, attrs);
        this.init(context);
    }

    public ScrollCalendar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initStyle(context, attrs);
        this.init(context);
    }

    private void init(@NonNull Context context) {
        this.setOrientation(1);
        ScrollCalendar.inflate((Context)context, (int)R.layout.scrollcalendar_calendar, (ViewGroup)this);
        for (int i = 0; i < this.legend.length; ++i) {
            this.legend[i] = new LegendItem(i + 1, this);
        }
    }

    private void initStyle(@NonNull Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ScrollCalendar, R.attr.scrollCalendarStyleAttr, R.style.ScrollCalendarStyle);
        this.selectedItemStyle = typedArray.getResourceId(R.styleable.ScrollCalendar_selectedItemStyle, 0);
        this.defaultAdapter = typedArray.getInt(Keys.ADAPTER, 0);
        this.firstDayOfWeek = typedArray.getInt(R.styleable.ScrollCalendar_firstDayOfWeek, -1);
        this.customFont = typedArray.getString(Keys.CUSTOM_FONT);
        this.monthTitleStyle = typedArray.getResourceId(R.styleable.ScrollCalendar_monthTitleStyle, 0);
        this.legendItemStyle = typedArray.getResourceId(R.styleable.ScrollCalendar_legendItemStyle, 0);
        this.currentDayStyle = typedArray.getResourceId(R.styleable.ScrollCalendar_currentDayStyle, 0);
        this.selectedBeginningDayStyle = typedArray.getResourceId(R.styleable.ScrollCalendar_selectedBeginningItemStyle, 0);
        this.legendSeparatorStyle = typedArray.getResourceId(R.styleable.ScrollCalendar_legendSeparatorStyle, 0);
        this.selectedMiddleDayStyle = typedArray.getResourceId(R.styleable.ScrollCalendar_selectedMiddleItemStyle, 0);
        this.selectedEndDayStyle = typedArray.getResourceId(R.styleable.ScrollCalendar_selectedEndItemStyle, 0);
        this.disabledItemStyle = typedArray.getResourceId(R.styleable.ScrollCalendar_disabledItemStyle, 0);
        this.unavailableItemStyle = typedArray.getResourceId(R.styleable.ScrollCalendar_unavailableItemStyle, 0);
        this.dayStyle = typedArray.getResourceId(R.styleable.ScrollCalendar_dayStyle, 0);
        this.showYearAlways = typedArray.getBoolean(R.styleable.ScrollCalendar_showYearAlways, false);
        this.softLineBreaks = typedArray.getBoolean(R.styleable.ScrollCalendar_roundLineBreaks, true);
        typedArray.recycle();
    }

    public void setOnDateClickListener(@Nullable OnDateClickListener calendarCallback) {
        this.getAdapter().setOnDateClickListener(calendarCallback);
    }

    public void refresh() {
        this.refreshLegend();
        this.getAdapter().notifyDataSetChanged();
    }

    public void setDateWatcher(@Nullable DateWatcher dateWatcher) {
        this.getAdapter().setDateWatcher(dateWatcher);
    }

    public void setMonthScrollListener(@Nullable MonthScrollListener monthScrollListener) {
        this.getAdapter().setMonthScrollListener(monthScrollListener);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.setupLegend();
        this.setupSeparatorStyle();
        this.setupRecyclerView();
    }

    private void setupLegend() {
        LinearLayout legendHolder = (LinearLayout)this.findViewById(R.id.legend);
        for (LegendItem legendItem : this.legend) {
            legendHolder.addView(legendItem.layout(legendHolder, this));
        }
        this.refreshLegend();
    }

    private void setupRecyclerView() {
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 1, false));
        recyclerView.setAdapter((RecyclerView.Adapter)this.getAdapter());
    }

    private void setupSeparatorStyle() {
        View separator = this.findViewById(R.id.separator);
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(this.legendSeparatorStyle, attrs);
        block4: for (int i = 0; i < attrs.length; ++i) {
            switch (attrs[i]) {
                case 16842964: {
                    int resourceId = typedArray.getResourceId(i, 0);
                    if (resourceId != 0) {
                        separator.setBackgroundResource(resourceId);
                        continue block4;
                    }
                    int color2 = typedArray.getColor(i, 0);
                    separator.setBackgroundColor(color2);
                    continue block4;
                }
                case 0x1010155: {
                    int resource = typedArray.getDimensionPixelSize(i, 0);
                    LinearLayoutCompat.LayoutParams params = new LinearLayoutCompat.LayoutParams(-1, resource);
                    separator.setLayoutParams((ViewGroup.LayoutParams)params);
                    continue block4;
                }
            }
        }
        typedArray.recycle();
    }

    private void refreshLegend() {
        for (LegendItem legendItem : this.legend) {
            legendItem.display();
        }
    }

    @NonNull
    public ScrollCalendarAdapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = this.createAdapter();
        }
        return this.adapter;
    }

    protected ScrollCalendarAdapter createAdapter() {
        MonthResProviderImpl monthResProvider = new MonthResProviderImpl(this.getContext(), this);
        DayResProviderImpl dayResProvider = new DayResProviderImpl(this.getContext(), this);
        switch (this.defaultAdapter) {
            case 1: {
                return new DefaultDateScrollCalendarAdapter(monthResProvider, dayResProvider, this);
            }
            case 2: {
                return new DefaultRangeScrollCalendarAdapter(monthResProvider, dayResProvider, this);
            }
        }
        return new ScrollCalendarAdapter(monthResProvider, dayResProvider, this);
    }

    @Override
    @StyleRes
    public int getMonthTitleStyle() {
        return this.monthTitleStyle;
    }

    @Override
    public int getLegendItemStyle() {
        return this.legendItemStyle;
    }

    @Override
    @StyleRes
    public int getCurrentDayStyle() {
        return this.currentDayStyle;
    }

    @Override
    @StyleRes
    public int getSelectedDayStyle() {
        return this.selectedItemStyle;
    }

    @Override
    @StyleRes
    public int getSelectedBeginningDayStyle() {
        return this.selectedBeginningDayStyle;
    }

    @Override
    @StyleRes
    public int getSelectedMiddleDayStyle() {
        return this.selectedMiddleDayStyle;
    }

    @Override
    @StyleRes
    public int getSelectedEndDayStyle() {
        return this.selectedEndDayStyle;
    }

    @Override
    @StyleRes
    public int getUnavailableItemStyle() {
        return this.unavailableItemStyle;
    }

    @Override
    @StyleRes
    public int getDayStyle() {
        return this.dayStyle;
    }

    @Override
    @StyleRes
    public int getDisabledItemStyle() {
        return this.disabledItemStyle;
    }

    @Override
    public boolean showYearAlways() {
        return this.showYearAlways;
    }

    @Override
    public boolean softLineBreaks() {
        return this.softLineBreaks;
    }

    @Override
    @Nullable
    public Typeface getCustomFont() {
        if (this.customFont == null) {
            return null;
        }
        try {
            return Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)this.customFont);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance();
        if (this.firstDayOfWeek != -1) {
            calendar.setFirstDayOfWeek(this.firstDayOfWeek);
        }
        return calendar;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        for (int i = 0; i < this.legend.length; ++i) {
            this.legend[i] = new LegendItem(i + 1, this);
        }
        LinearLayout legendHolder = (LinearLayout)this.findViewById(R.id.legend);
        legendHolder.removeAllViews();
        this.setupLegend();
        this.adapter.notifyDataSetChanged();
    }
}

