/*
 * Decompiled with CFR 0.152.
 */
package pl.rafman.scrollcalendar.adapter.example;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Calendar;
import java.util.Date;
import pl.rafman.scrollcalendar.adapter.ScrollCalendarAdapter;
import pl.rafman.scrollcalendar.style.DayResProvider;
import pl.rafman.scrollcalendar.style.MonthResProvider;

public class DefaultRangeScrollCalendarAdapter
extends ScrollCalendarAdapter {
    @Nullable
    private Calendar from;
    @Nullable
    private Calendar until;

    public DefaultRangeScrollCalendarAdapter(@NonNull MonthResProvider monthResProvider, @NonNull DayResProvider dayResProvider) {
        super(monthResProvider, dayResProvider);
    }

    @Override
    protected void onCalendarDayClicked(int year, int month, int day) {
        if (this.isInThePast(year, month, day)) {
            return;
        }
        Calendar clickedOn = Calendar.getInstance();
        clickedOn.set(1, year);
        clickedOn.set(2, month);
        clickedOn.set(5, day);
        clickedOn.set(11, 0);
        clickedOn.set(12, 0);
        clickedOn.set(13, 0);
        clickedOn.set(14, 0);
        if (this.shouldClearAllSelected(clickedOn)) {
            this.from = null;
            this.until = null;
        } else if (this.shouldSetFrom(clickedOn)) {
            this.from = clickedOn;
            this.until = null;
        } else if (this.shouldSetUntil()) {
            this.until = clickedOn;
        }
        super.onCalendarDayClicked(year, month, day);
    }

    @Override
    protected int getStateForDate(int year, int month, int day) {
        if (this.isInThePast(year, month, day)) {
            return 1;
        }
        if (this.isInRange(this.from, this.until, year, month, day)) {
            if (this.until == null) {
                return 7;
            }
            if (this.isSelected(this.from, year, month, day)) {
                return 5;
            }
            if (this.isSelected(this.until, year, month, day)) {
                return 6;
            }
            return 4;
        }
        if (this.isToday(year, month, day)) {
            return 2;
        }
        return 0;
    }

    private boolean isInRange(Calendar from, Calendar until, int year, int month, int day) {
        if (from == null || until == null) {
            return from != null && this.isSelected(from, year, month, day);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, from.get(1));
        calendar.set(2, from.get(2));
        calendar.set(5, from.get(5));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long millis1 = calendar.getTimeInMillis();
        calendar.set(1, until.get(1));
        calendar.set(2, until.get(2));
        calendar.set(5, until.get(5));
        long millis2 = calendar.getTimeInMillis();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        long millis3 = calendar.getTimeInMillis();
        return millis1 <= millis3 && millis2 >= millis3;
    }

    private boolean shouldSetUntil() {
        return this.until == null;
    }

    private boolean shouldClearAllSelected(Calendar calendar) {
        return this.from != null && this.from.equals(calendar);
    }

    private boolean shouldSetFrom(Calendar calendar) {
        return this.from == null || this.until != null || this.isBefore(this.from, calendar);
    }

    private boolean isBefore(Calendar c1, Calendar c2) {
        if (c1 == null || c2 == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, c2.get(1));
        calendar.set(2, c2.get(2));
        calendar.set(5, c2.get(5));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long millis = calendar.getTimeInMillis();
        calendar.set(1, c1.get(1));
        calendar.set(2, c1.get(2));
        calendar.set(5, c1.get(5));
        long millis2 = calendar.getTimeInMillis();
        return millis < millis2;
    }

    private boolean isInThePast(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 1);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long now = calendar.getTimeInMillis();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        long then = calendar.getTimeInMillis();
        return now > then;
    }

    @Override
    protected boolean isAllowedToAddPreviousMonth() {
        return false;
    }

    @Override
    protected boolean isAllowedToAddNextMonth() {
        return true;
    }

    private boolean isSelected(Calendar selected, int year, int month, int day) {
        if (selected == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, selected.get(1));
        calendar.set(2, selected.get(2));
        calendar.set(5, selected.get(5));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long millis = calendar.getTimeInMillis();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        long millis2 = calendar.getTimeInMillis();
        return millis == millis2;
    }

    private boolean isToday(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long today = calendar.getTime().getTime();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        long calendarMillis = calendar.getTime().getTime();
        return today == calendarMillis;
    }

    @Nullable
    public Date getStartDate() {
        return this.from != null ? this.from.getTime() : null;
    }

    @Nullable
    public Date getEndDate() {
        return this.until != null ? this.until.getTime() : null;
    }
}

