/*
 * Decompiled with CFR 0.152.
 */
package pl.rafman.scrollcalendar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import pl.rafman.scrollcalendar.R;
import pl.rafman.scrollcalendar.adapter.ResProvider;

public class LegendItem {
    private static final char[] days;
    private static final int[] attrs;
    private final int dayOfWeek;
    @Nullable
    private TextView textView;

    public LegendItem(int dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public View layout(LinearLayout parent, ResProvider resProvider) {
        if (this.textView == null) {
            this.textView = (TextView)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.scrollcalendar_day_legend, (ViewGroup)parent, false);
            TypedArray typedArray = this.textView.getContext().getTheme().obtainStyledAttributes(resProvider.getLegendItemStyle(), attrs);
            block6: for (int i = 0; i < attrs.length; ++i) {
                switch (attrs[i]) {
                    case 16842904: {
                        this.textView.setTextColor(typedArray.getColor(i, ContextCompat.getColor((Context)this.textView.getContext(), (int)17170444)));
                        continue block6;
                    }
                    case 16842901: {
                        this.textView.setTextSize(0, (float)typedArray.getDimensionPixelSize(i, 16));
                        continue block6;
                    }
                    case 16842927: {
                        this.textView.setGravity(typedArray.getInt(i, 17));
                        continue block6;
                    }
                    case 16842965: {
                        int padding = typedArray.getDimensionPixelOffset(i, 0);
                        this.textView.setPadding(padding, padding, padding, padding);
                        continue block6;
                    }
                }
            }
            typedArray.recycle();
            Typeface typeface = resProvider.getCustomFont();
            if (typeface != null) {
                this.textView.setTypeface(typeface);
            }
        }
        return this.textView;
    }

    public void display() {
        if (this.textView != null) {
            this.textView.setText((CharSequence)this.getReadableSymbol());
        }
    }

    private String getReadableSymbol() {
        return String.valueOf(days[this.dayOfWeek - 1]);
    }

    static {
        attrs = new int[]{16842904, 16842901, 16842965, 16842927};
        Arrays.sort(attrs);
        String[] original = new DateFormatSymbols().getWeekdays();
        ArrayList<Character> characters = new ArrayList<Character>();
        for (String s : original) {
            if (s == null || s.isEmpty()) continue;
            characters.add(Character.valueOf(s.toUpperCase(Locale.US).charAt(0)));
        }
        days = new char[characters.size()];
        for (int i = 0; i < days.length; ++i) {
            LegendItem.days[i] = ((Character)characters.get(i)).charValue();
        }
    }
}

