/*
 * Decompiled with CFR 0.152.
 */
package pl.rafman.scrollcalendar;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.Dimension;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import pl.rafman.scrollcalendar.R;
import pl.rafman.scrollcalendar.adapter.LegendItem;
import pl.rafman.scrollcalendar.adapter.ResProvider;
import pl.rafman.scrollcalendar.adapter.ScrollCalendarAdapter;
import pl.rafman.scrollcalendar.adapter.example.DefaultDateScrollCalendarAdapter;
import pl.rafman.scrollcalendar.adapter.example.DefaultRangeScrollCalendarAdapter;
import pl.rafman.scrollcalendar.contract.DateWatcher;
import pl.rafman.scrollcalendar.contract.MonthScrollListener;
import pl.rafman.scrollcalendar.contract.OnDateClickListener;
import pl.rafman.scrollcalendar.values.Defaults;
import pl.rafman.scrollcalendar.values.Keys;

public class ScrollCalendar
extends LinearLayoutCompat
implements ResProvider {
    @ColorInt
    private int fontColor;
    @ColorInt
    private int backgroundColor;
    @ColorInt
    private int disabledTextColor;
    @ColorInt
    private int unavailableTextColor;
    @ColorInt
    private int selectedTextColor;
    @ColorInt
    private int todayTextColor;
    @DrawableRes
    private int unavailableBackground;
    @DrawableRes
    private int selectedBackground;
    @DrawableRes
    private int selectedBackgroundBeginning;
    @DrawableRes
    private int selectedBackgroundEnd;
    @DrawableRes
    private int selectedBackgroundMiddle;
    @DrawableRes
    private int currentDayBackground;
    @ColorInt
    private int disabledBackgroundColor;
    @Dimension
    private float fontSize;
    @Nullable
    private String customFont;
    private final LegendItem[] legend = new LegendItem[7];
    @Nullable
    private ScrollCalendarAdapter adapter;
    private int defaultAdapter;

    public ScrollCalendar(Context context) {
        super(context);
        this.init(context);
    }

    public ScrollCalendar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initStyle(context, attrs);
        this.init(context);
    }

    public ScrollCalendar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initStyle(context, attrs);
        this.init(context);
    }

    private void init(@NonNull Context context) {
        this.setOrientation(1);
        ScrollCalendar.inflate((Context)context, (int)R.layout.scrollcalendar_calendar, (ViewGroup)this);
        for (int i = 0; i < this.legend.length; ++i) {
            this.legend[i] = new LegendItem(i + 1);
        }
    }

    private void initStyle(@NonNull Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ScrollCalendar, R.attr.scrollCalendarStyleAttr, R.style.ScrollCalendarStyle);
        this.currentDayBackground = typedArray.getResourceId(Keys.CURRENT_DAY_BG, Defaults.CURRENT_DAY_BG);
        this.fontColor = typedArray.getColor(Keys.FONT_COLOR, ContextCompat.getColor((Context)context, (int)17170444));
        this.backgroundColor = typedArray.getColor(Keys.BACKGROUND_COLOR, ContextCompat.getColor((Context)context, (int)17170445));
        this.disabledTextColor = typedArray.getColor(Keys.DISABLED_TEXT_COLOR, ContextCompat.getColor((Context)context, (int)0x1060000));
        this.disabledBackgroundColor = typedArray.getColor(Keys.DISABLED_BACKGROUND_COLOR, ContextCompat.getColor((Context)context, (int)17170445));
        this.unavailableTextColor = typedArray.getColor(Keys.UNAVAILABLE_TEXT_COLOR, ContextCompat.getColor((Context)context, (int)0x1060000));
        this.selectedTextColor = typedArray.getColor(Keys.SELECTED_TEXT_COLOR, ContextCompat.getColor((Context)context, (int)0x1060000));
        this.todayTextColor = typedArray.getColor(Keys.TODAY_TEXT_COLOR, ContextCompat.getColor((Context)context, (int)17170444));
        this.unavailableBackground = typedArray.getResourceId(Keys.UNAVAILABLE_BACKGROUND, Defaults.UNAVAILABLE_BACKGROUND);
        this.selectedBackground = typedArray.getResourceId(Keys.SELECTED_BACKGROUND, Defaults.SELECTED_BACKGROUND);
        this.selectedBackgroundBeginning = typedArray.getResourceId(Keys.SELECTED_BACKGROUND_BEGINNING, Defaults.SELECTED_BACKGROUND_BEGINNING);
        this.selectedBackgroundMiddle = typedArray.getResourceId(Keys.SELECTED_BACKGROUND_MIDDLE, Defaults.SELECTED_BACKGROUND_MIDDLE);
        this.selectedBackgroundEnd = typedArray.getResourceId(Keys.SELECTED_BACKGROUND_END, Defaults.SELECTED_BACKGROUND_END);
        this.defaultAdapter = typedArray.getInt(Keys.ADAPTER, 0);
        this.fontSize = typedArray.getDimension(Keys.FONT_SIZE, (float)this.getResources().getDimensionPixelSize(Defaults.FONT_SIZE));
        this.customFont = typedArray.getString(Keys.CUSTOM_FONT);
        typedArray.recycle();
    }

    public void setOnDateClickListener(@Nullable OnDateClickListener calendarCallback) {
        this.getAdapter().setOnDateClickListener(calendarCallback);
    }

    public void refresh() {
        this.refreshLegend();
        this.getAdapter().notifyDataSetChanged();
    }

    public void setDateWatcher(@Nullable DateWatcher dateWatcher) {
        this.getAdapter().setDateWatcher(dateWatcher);
    }

    public void setMonthScrollListener(@Nullable MonthScrollListener monthScrollListener) {
        this.getAdapter().setMonthScrollListener(monthScrollListener);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        LinearLayout legendHolder = (LinearLayout)this.findViewById(R.id.legend);
        for (LegendItem legendItem : this.legend) {
            legendHolder.addView(legendItem.layout(legendHolder, this));
        }
        this.refreshLegend();
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 1, false));
        recyclerView.setAdapter((RecyclerView.Adapter)this.getAdapter());
    }

    private void refreshLegend() {
        for (LegendItem legendItem : this.legend) {
            legendItem.display();
        }
    }

    @NonNull
    public ScrollCalendarAdapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = this.createAdapter();
        }
        return this.adapter;
    }

    private ScrollCalendarAdapter createAdapter() {
        switch (this.defaultAdapter) {
            case 1: {
                return new DefaultDateScrollCalendarAdapter(this);
            }
            case 2: {
                return new DefaultRangeScrollCalendarAdapter(this);
            }
        }
        return new ScrollCalendarAdapter(this);
    }

    @Override
    @ColorInt
    public int defaultFontColor() {
        return this.fontColor;
    }

    @Override
    @ColorInt
    public int defaultBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    @ColorInt
    public int disabledTextColor() {
        return this.disabledTextColor;
    }

    @Override
    @ColorInt
    public int disabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    @Override
    @ColorInt
    public int todayTextColor() {
        return this.todayTextColor;
    }

    @Override
    @ColorInt
    public int unavailableTextColor() {
        return this.unavailableTextColor;
    }

    @Override
    @ColorInt
    public int selectedTextColor() {
        return this.selectedTextColor;
    }

    @Override
    @DrawableRes
    public int todayBackground() {
        return this.currentDayBackground;
    }

    @Override
    @DrawableRes
    public int unavailableBackgroundColor() {
        return this.unavailableBackground;
    }

    @Override
    public int selectedBackgroundColor() {
        return this.selectedBackground;
    }

    @Override
    public int selectedBeginningBackgroundColor() {
        return this.selectedBackgroundBeginning;
    }

    @Override
    public int selectedEndBackgroundColor() {
        return this.selectedBackgroundEnd;
    }

    @Override
    public int selectedMiddleBackgroundColor() {
        return this.selectedBackgroundMiddle;
    }

    @Override
    @Dimension
    public float fontSize() {
        return this.fontSize;
    }

    @Override
    @Nullable
    public Typeface getCustomFont() {
        if (this.customFont == null) {
            return null;
        }
        try {
            return Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)this.customFont);
        }
        catch (Exception e) {
            return null;
        }
    }
}

