/*
 * Decompiled with CFR 0.152.
 */
package pl.rafman.scrollcalendar.adapter;

import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import pl.rafman.scrollcalendar.R;
import pl.rafman.scrollcalendar.adapter.ResProvider;

public class LegendItem {
    private static final char[] days;
    private final int dayOfWeek;
    @Nullable
    private TextView textView;

    public LegendItem(int dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public View layout(LinearLayout parent, ResProvider resProvider) {
        if (this.textView == null) {
            this.textView = (TextView)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.scrollcalendar_day, (ViewGroup)parent, false);
            if (this.textView != null) {
                Typeface typeface = resProvider.getCustomFont();
                if (typeface != null) {
                    this.textView.setTypeface(typeface);
                }
                this.textView.setTextSize(0, resProvider.fontSize());
            }
        }
        return this.textView;
    }

    public void display() {
        if (this.textView != null) {
            this.textView.setText((CharSequence)this.getReadableSymbol());
        }
    }

    private String getReadableSymbol() {
        return String.valueOf(days[this.dayOfWeek - 1]);
    }

    static {
        String[] original = new DateFormatSymbols().getWeekdays();
        ArrayList<Character> characters = new ArrayList<Character>();
        for (String s : original) {
            if (s == null || s.isEmpty()) continue;
            characters.add(Character.valueOf(s.toUpperCase().charAt(0)));
        }
        days = new char[characters.size()];
        for (int i = 0; i < days.length; ++i) {
            LegendItem.days[i] = ((Character)characters.get(i)).charValue();
        }
    }
}

