/*
 * Decompiled with CFR 0.152.
 */
package pl.rafman.scrollcalendar.adapter;

import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import pl.rafman.scrollcalendar.R;
import pl.rafman.scrollcalendar.adapter.ResProvider;
import pl.rafman.scrollcalendar.contract.ClickCallback;
import pl.rafman.scrollcalendar.data.CalendarDay;
import pl.rafman.scrollcalendar.data.CalendarMonth;
import pl.rafman.scrollcalendar.widgets.SquareTextView;

class DayHolder
implements View.OnClickListener {
    @NonNull
    private final ClickCallback calendarCallback;
    @Nullable
    private SquareTextView textView;
    private final ResProvider resProvider;
    @Nullable
    private CalendarMonth calendarMonth;
    @Nullable
    private CalendarDay currentDay;

    DayHolder(@NonNull ClickCallback calendarCallback, @NonNull ResProvider resProvider) {
        this.calendarCallback = calendarCallback;
        this.resProvider = resProvider;
    }

    public View layout(LinearLayout parent) {
        if (this.textView == null) {
            this.textView = (SquareTextView)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.scrollcalendar_day, (ViewGroup)parent, false);
            this.textView.setOnClickListener(this);
            this.textView.setTextSize(0, this.resProvider.fontSize());
        }
        return this.textView;
    }

    void display(@Nullable CalendarMonth calendarMonth, @Nullable CalendarDay currentDay, @Nullable CalendarDay previousDay, @Nullable CalendarDay nextDay) {
        this.calendarMonth = calendarMonth;
        this.currentDay = currentDay;
        this.refreshAppearance(currentDay);
        this.refreshStyle(currentDay, previousDay, nextDay);
    }

    private void refreshAppearance(@Nullable CalendarDay calendarDay) {
        if (this.textView == null) {
            return;
        }
        if (calendarDay == null) {
            this.textView.setVisibility(4);
        } else {
            this.textView.setVisibility(0);
            this.textView.setText(String.valueOf(calendarDay.getDay()));
        }
    }

    private void refreshStyle(@Nullable CalendarDay currentDay, @Nullable CalendarDay previousDay, @Nullable CalendarDay nextDay) {
        if (this.textView == null) {
            return;
        }
        if (currentDay != null) {
            switch (currentDay.getState()) {
                case 4: {
                    if (this.hasNoNeighbours(previousDay, nextDay)) {
                        this.textView.setTextColor(this.resProvider.selectedTextColor());
                        this.textView.setBackgroundResource(this.resProvider.selectedBackgroundColor());
                        this.setFont(this.resProvider.getCustomFont());
                        break;
                    }
                    if (this.isBeginning(previousDay)) {
                        this.textView.setTextColor(this.resProvider.selectedTextColor());
                        this.textView.setBackgroundResource(this.resProvider.selectedBeginningBackgroundColor());
                        this.setFont(this.resProvider.getCustomFont());
                        break;
                    }
                    if (this.isMiddle(previousDay, nextDay)) {
                        this.textView.setTextColor(this.resProvider.selectedTextColor());
                        this.textView.setBackgroundResource(this.resProvider.selectedMiddleBackgroundColor());
                        this.setFont(this.resProvider.getCustomFont());
                        break;
                    }
                    if (!this.isEnd(nextDay)) break;
                    this.textView.setTextColor(this.resProvider.selectedTextColor());
                    this.textView.setBackgroundResource(this.resProvider.selectedEndBackgroundColor());
                    this.setFont(this.resProvider.getCustomFont());
                    break;
                }
                case 3: {
                    this.textView.setTextColor(this.resProvider.unavailableTextColor());
                    this.textView.setBackgroundResource(this.resProvider.unavailableBackgroundColor());
                    this.setFont(this.resProvider.getCustomFont());
                    break;
                }
                case 1: {
                    this.textView.setTextColor(this.resProvider.disabledTextColor());
                    this.textView.setBackgroundColor(this.resProvider.disabledBackgroundColor());
                    this.setFont(this.resProvider.getCustomFont());
                    break;
                }
                case 2: {
                    this.textView.setTextColor(this.resProvider.todayTextColor());
                    this.textView.setBackgroundResource(this.resProvider.todayBackground());
                    this.setFont(this.resProvider.getCustomFont());
                    break;
                }
                default: {
                    this.textView.setTextColor(this.resProvider.defaultFontColor());
                    this.textView.setBackgroundColor(this.resProvider.defaultBackgroundColor());
                    this.setFont(this.resProvider.getCustomFont());
                }
            }
        }
    }

    private boolean isEnd(CalendarDay nextDay) {
        return !this.isSelected(nextDay);
    }

    private boolean isMiddle(CalendarDay previousDay, CalendarDay nextDay) {
        return this.isSelected(previousDay) && this.isSelected(nextDay);
    }

    private boolean isBeginning(@Nullable CalendarDay previousDay) {
        return !this.isSelected(previousDay);
    }

    private boolean hasNoNeighbours(@Nullable CalendarDay previousDay, @Nullable CalendarDay nextDay) {
        return !this.isSelected(previousDay) && !this.isSelected(nextDay);
    }

    private boolean isSelected(@Nullable CalendarDay previousDay) {
        return previousDay != null && previousDay.getState() == 4;
    }

    private void setFont(Typeface customFont) {
        if (this.textView == null) {
            return;
        }
        if (customFont != null) {
            this.textView.setTypeface(customFont);
        }
    }

    public void onClick(View view) {
        if (this.calendarMonth != null && this.currentDay != null) {
            this.calendarCallback.onCalendarDayClicked(this.calendarMonth, this.currentDay);
        }
    }
}

