/*
 * Decompiled with CFR 0.152.
 */
package pl.rafman.scrollcalendar.adapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import pl.rafman.scrollcalendar.adapter.MonthViewHolder;
import pl.rafman.scrollcalendar.adapter.ResProvider;
import pl.rafman.scrollcalendar.contract.ClickCallback;
import pl.rafman.scrollcalendar.contract.DateWatcher;
import pl.rafman.scrollcalendar.contract.MonthScrollListener;
import pl.rafman.scrollcalendar.contract.OnDateClickListener;
import pl.rafman.scrollcalendar.data.CalendarDay;
import pl.rafman.scrollcalendar.data.CalendarMonth;

public class ScrollCalendarAdapter
extends RecyclerView.Adapter<MonthViewHolder>
implements ClickCallback {
    @NonNull
    private final List<CalendarMonth> months = new ArrayList<CalendarMonth>();
    @Nullable
    private RecyclerView recyclerView;
    @NonNull
    private final ResProvider resProvider;
    @Nullable
    private MonthScrollListener monthScrollListener;
    @Nullable
    private OnDateClickListener onDateClickListener;
    @Nullable
    private DateWatcher dateWatcher;

    public ScrollCalendarAdapter(@NonNull ResProvider resProvider) {
        this.resProvider = resProvider;
        this.months.add(CalendarMonth.now());
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.recyclerView = recyclerView;
    }

    public MonthViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return MonthViewHolder.create(parent, this, this.resProvider);
    }

    public void onBindViewHolder(MonthViewHolder holder, int position) {
        CalendarMonth month = this.getItem(position);
        this.prepare(month);
        holder.bind(month);
        this.afterBindViewHolder(position);
    }

    private void afterBindViewHolder(int position) {
        if (this.recyclerView != null) {
            if (this.shouldAddPreviousMonth(position)) {
                this.recyclerView.post(new Runnable(){

                    @Override
                    public void run() {
                        ScrollCalendarAdapter.this.prependCalendarMonth();
                    }
                });
            }
            if (this.shouldAddNextMonth(position)) {
                this.recyclerView.post(new Runnable(){

                    @Override
                    public void run() {
                        ScrollCalendarAdapter.this.appendCalendarMonth();
                    }
                });
            }
        }
    }

    private boolean shouldAddPreviousMonth(int position) {
        return this.isNearTop(position) && this.isAllowedToAddPreviousMonth();
    }

    private boolean isAllowedToAddPreviousMonth() {
        if (this.monthScrollListener == null) {
            return true;
        }
        CalendarMonth item = this.getFirstItem();
        return this.monthScrollListener.shouldAddPreviousMonth(item.getYear(), item.getMonth());
    }

    private boolean shouldAddNextMonth(int position) {
        return this.isNearBottom(position) && this.isAllowedToAddNextMonth();
    }

    private boolean isAllowedToAddNextMonth() {
        if (this.monthScrollListener == null) {
            return true;
        }
        CalendarMonth item = this.getLastItem();
        return this.monthScrollListener.shouldAddNextMonth(item.getYear(), item.getMonth());
    }

    private void prepare(CalendarMonth month) {
        for (CalendarDay calendarDay : month.getDays()) {
            calendarDay.setState(this.makeState(month, calendarDay));
        }
    }

    private int makeState(CalendarMonth month, CalendarDay calendarDay) {
        if (this.dateWatcher == null) {
            return 0;
        }
        int year = month.getYear();
        int monthInt = month.getMonth();
        int day = calendarDay.getDay();
        return this.dateWatcher.getStateForDate(year, monthInt, day);
    }

    private void prependCalendarMonth() {
        if (this.recyclerView != null) {
            this.months.add(0, this.getFirstItem().previous());
            this.notifyItemInserted(0);
        }
    }

    private void appendCalendarMonth() {
        this.months.add(this.getLastItem().next());
        this.notifyItemInserted(this.months.size() - 1);
    }

    private CalendarMonth getFirstItem() {
        return this.months.get(0);
    }

    private CalendarMonth getLastItem() {
        return this.months.get(this.months.size() - 1);
    }

    private CalendarMonth getItem(int position) {
        return this.months.get(position);
    }

    private boolean isNearTop(int position) {
        return position == 0;
    }

    private boolean isNearBottom(int position) {
        return this.months.size() - 1 <= position;
    }

    public int getItemCount() {
        return this.months.size();
    }

    public void setOnDateClickListener(@Nullable OnDateClickListener onDateClickListener) {
        this.onDateClickListener = onDateClickListener;
    }

    public void setMonthScrollListener(@Nullable MonthScrollListener monthScrollListener) {
        this.monthScrollListener = monthScrollListener;
    }

    public void setDateWatcher(@Nullable DateWatcher dateWatcher) {
        this.dateWatcher = dateWatcher;
    }

    @Override
    public void onCalendarDayClicked(@NonNull CalendarMonth calendarMonth, @NonNull CalendarDay calendarDay) {
        if (this.onDateClickListener != null) {
            int year = calendarMonth.getYear();
            int month = calendarMonth.getMonth();
            int day = calendarDay.getDay();
            this.onDateClickListener.onCalendarDayClicked(year, month, day);
            this.notifyDataSetChanged();
        }
    }
}

