/*
 * Decompiled with CFR 0.152.
 */
package pl.rafalmanka.scrollcalendar.adapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import pl.rafalmanka.scrollcalendar.adapter.MonthViewHolder;
import pl.rafalmanka.scrollcalendar.adapter.ResProvider;
import pl.rafalmanka.scrollcalendar.contract.ClickCallback;
import pl.rafalmanka.scrollcalendar.contract.ScrollCalendarCallback;
import pl.rafalmanka.scrollcalendar.data.CalendarDay;
import pl.rafalmanka.scrollcalendar.data.CalendarMonth;

public class ScrollCalendarAdapter
extends RecyclerView.Adapter<MonthViewHolder>
implements ClickCallback {
    @NonNull
    private final List<CalendarMonth> months = new ArrayList<CalendarMonth>();
    @Nullable
    private ScrollCalendarCallback calendarCallback;
    @Nullable
    private View recyclerView;
    @NonNull
    private final ResProvider resProvider;

    public ScrollCalendarAdapter(@NonNull ResProvider resProvider) {
        this.resProvider = resProvider;
        this.months.add(CalendarMonth.now());
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.recyclerView = recyclerView;
    }

    public MonthViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return MonthViewHolder.create(parent, this, this.resProvider);
    }

    public void onBindViewHolder(MonthViewHolder holder, int position) {
        CalendarMonth month = this.getItem(position);
        this.prepare(month);
        holder.bind(month);
        this.afterBindViewHolder(position);
    }

    private void afterBindViewHolder(int position) {
        if (this.recyclerView != null && this.shouldAddNextMonth(position)) {
            this.recyclerView.post(new Runnable(){

                @Override
                public void run() {
                    ScrollCalendarAdapter.this.appendCalendarMonth();
                }
            });
        }
    }

    private boolean shouldAddNextMonth(int position) {
        return this.isNearBottom(position) && this.isAllowedToAddNextMonth();
    }

    private boolean isAllowedToAddNextMonth() {
        if (this.calendarCallback == null) {
            return true;
        }
        CalendarMonth item = this.getLastItem();
        return this.calendarCallback.shouldAddNextMonth(item.getYear(), item.getMonth());
    }

    private void prepare(CalendarMonth month) {
        for (CalendarDay calendarDay : month.getDays()) {
            calendarDay.setState(this.makeState(month, calendarDay));
        }
    }

    private int makeState(CalendarMonth month, CalendarDay calendarDay) {
        if (this.calendarCallback == null) {
            return 0;
        }
        int year = month.getYear();
        int monthInt = month.getMonth();
        int day = calendarDay.getDay();
        return this.calendarCallback.getStateForDate(year, monthInt, day);
    }

    private void appendCalendarMonth() {
        this.months.add(this.getLastItem().next());
        this.notifyDataSetChanged();
    }

    private CalendarMonth getLastItem() {
        return this.months.get(this.months.size() - 1);
    }

    private CalendarMonth getItem(int position) {
        return this.months.get(position);
    }

    private boolean isNearBottom(int position) {
        return this.months.size() - 1 <= position;
    }

    public int getItemCount() {
        return this.months.size();
    }

    public void setCallback(@Nullable ScrollCalendarCallback calendarCallback) {
        this.calendarCallback = calendarCallback;
    }

    @Override
    public void onCalendarDayClicked(@NonNull CalendarMonth calendarMonth, @NonNull CalendarDay calendarDay) {
        if (this.calendarCallback != null) {
            int year = calendarMonth.getYear();
            int month = calendarMonth.getMonth();
            int day = calendarDay.getDay();
            this.calendarCallback.onCalendarDayClicked(year, month, day);
            this.notifyDataSetChanged();
        }
    }
}

