/*
 * Decompiled with CFR 0.152.
 */
package pl.rafalmanka.scrollcalendar.adapter;

import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Calendar;
import pl.rafalmanka.scrollcalendar.R;
import pl.rafalmanka.scrollcalendar.adapter.ResProvider;
import pl.rafalmanka.scrollcalendar.adapter.WeekHolder;
import pl.rafalmanka.scrollcalendar.contract.ClickCallback;
import pl.rafalmanka.scrollcalendar.data.CalendarDay;
import pl.rafalmanka.scrollcalendar.data.CalendarMonth;

class MonthViewHolder
extends RecyclerView.ViewHolder {
    @Nullable
    private final TextView title;
    private final WeekHolder[] weeks = new WeekHolder[6];

    private MonthViewHolder(@NonNull View rootView, @NonNull ClickCallback calendarCallback, @NonNull ResProvider resProvider) {
        super(rootView);
        LinearLayout monthContainer = (LinearLayout)rootView.findViewById(R.id.monthContainer);
        this.title = (TextView)rootView.findViewById(R.id.title);
        Typeface typeface = resProvider.getCustomFont();
        if (typeface != null) {
            this.title.setTypeface(typeface);
        }
        this.title.setTextSize(0, resProvider.fontSize());
        for (int i = 0; i < this.weeks.length; ++i) {
            this.weeks[i] = new WeekHolder(calendarCallback, resProvider);
        }
        for (WeekHolder week : this.weeks) {
            monthContainer.addView(week.layout(monthContainer));
        }
    }

    MonthViewHolder(View rootView) {
        super(rootView);
        this.title = null;
    }

    static MonthViewHolder create(@NonNull ViewGroup parent, @NonNull ClickCallback calendarCallback, @NonNull ResProvider resProvider) {
        return new MonthViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.scrollcalendar_month, parent, false), calendarCallback, resProvider);
    }

    void bind(CalendarMonth month) {
        if (this.title != null) {
            this.title.setText((CharSequence)month.getReadableMonthName());
        }
        for (int i = 1; i <= this.weeks.length; ++i) {
            this.weeks[i - 1].display(i, month, this.filterWeekDays(i, month));
        }
    }

    CalendarDay[] filterWeekDays(int weekOfMonth, CalendarMonth calendarMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, calendarMonth.getYear());
        calendar.set(2, calendarMonth.getMonth());
        calendar.set(5, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        ArrayList<CalendarDay> days = new ArrayList<CalendarDay>();
        for (CalendarDay calendarDay : calendarMonth.getDays()) {
            calendar.set(5, calendarDay.getDay());
            if (calendar.get(4) != weekOfMonth) continue;
            days.add(calendarDay);
        }
        return days.toArray(new CalendarDay[days.size()]);
    }
}

