/*
 * Decompiled with CFR 0.152.
 */
package junitparams;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import javax.lang.model.type.NullType;
import junitparams.InvokeParameterisedMethod;
import junitparams.Parameters;
import junitparams.TestMethod;
import junitparams.Utils;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.Statement;

public class ParameterisedTestMethodRunner {
    private int count;
    private final TestMethod method;
    private Parameters parametersAnnotation;

    public ParameterisedTestMethodRunner(TestMethod testMethod) {
        this.method = testMethod;
        this.parametersAnnotation = (Parameters)testMethod.frameworkMethod.getAnnotation(Parameters.class);
    }

    public int nextCount() {
        return this.count++;
    }

    public int count() {
        return this.count;
    }

    Object[] paramsFromAnnotation() {
        Object[] params = this.paramsFromValue();
        if (params.length == 0) {
            params = this.paramsFromSource();
        }
        if (params.length == 0) {
            params = this.paramsFromMethod();
        }
        if (params.length == 0) {
            throw new RuntimeException("No parameters found, even though the method is defined as Prameterised. There aren't any params in the annotation, there's no test class method providing the params and no external provider...");
        }
        return params;
    }

    private Object[] paramsFromValue() {
        Object[] params = this.parametersAnnotation.value();
        return params;
    }

    private Object[] paramsFromSource() {
        if (this.sourceClassUndefined()) {
            return new Object[0];
        }
        Class<?> sourceClass = this.parametersAnnotation.source();
        return this.fillResultWithAllParamProviderMethods(sourceClass);
    }

    private Object[] fillResultWithAllParamProviderMethods(Class<?> sourceClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (sourceClass.getSuperclass() != null) {
            result.addAll(this.gatherParamsFromAllMethodsFrom(sourceClass));
            sourceClass = sourceClass.getSuperclass();
        }
        if (result.isEmpty()) {
            throw new RuntimeException("No methods starting with provide or they return no result in the parameters source class: " + sourceClass.getName());
        }
        return result.toArray(new Object[0]);
    }

    private ArrayList<Object> gatherParamsFromAllMethodsFrom(Class<?> sourceClass) {
        Method[] methods;
        ArrayList<Object> result = new ArrayList<Object>();
        for (Method method : methods = sourceClass.getDeclaredMethods()) {
            if (!method.getName().startsWith("provide")) continue;
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new RuntimeException("Parameters source method " + method.getName() + " is not declared as static. Modify it to a static method.");
            }
            try {
                result.addAll(Arrays.asList(this.processParamsIfSingle((Object[])method.invoke(null, new Object[0]))));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot invoke parameters source method: " + method.getName(), e);
            }
        }
        return result;
    }

    private boolean sourceClassUndefined() {
        return this.parametersAnnotation.source().isAssignableFrom(NullType.class);
    }

    private Object[] paramsFromMethod() {
        String methodName = this.parametersAnnotation.method();
        if ("".equals(methodName)) {
            methodName = this.defaultMethodName();
        }
        return this.invokeMethodWithParams(methodName);
    }

    private Object[] invokeMethodWithParams(String methodName) {
        Class<?> testClass = this.method.frameworkMethod.getMethod().getDeclaringClass();
        Method provideMethod = this.findParamsProvidingMethodInTestclassHierarchy(methodName, testClass);
        return this.invokeParamsProvidingMethod(testClass, provideMethod);
    }

    private Object[] invokeParamsProvidingMethod(Class<?> testClass, Method provideMethod) {
        try {
            Object testObject = testClass.newInstance();
            provideMethod.setAccessible(true);
            Object[] params = (Object[])provideMethod.invoke(testObject, new Object[0]);
            return this.processParamsIfSingle(params);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not invoke method: " + provideMethod.getName() + " defined in class " + testClass + " so no params were used.", e);
        }
    }

    private Object[] processParamsIfSingle(Object[] params) {
        if (this.method.frameworkMethod.getMethod().getParameterTypes().length != params.length) {
            return params;
        }
        if (params.length == 0) {
            return params;
        }
        Object param = params[0];
        if (param == null || !param.getClass().isArray()) {
            return new Object[]{params};
        }
        return params;
    }

    private Method findParamsProvidingMethodInTestclassHierarchy(String methodName, Class<?> testClass) {
        Method provideMethod = null;
        Class<?> declaringClass = testClass;
        while (declaringClass.getSuperclass() != null) {
            try {
                provideMethod = declaringClass.getDeclaredMethod(methodName, new Class[0]);
                break;
            }
            catch (Exception e) {
                declaringClass = declaringClass.getSuperclass();
            }
        }
        if (provideMethod == null) {
            throw new RuntimeException("Could not find method: " + methodName + " so no params were used.");
        }
        return provideMethod;
    }

    private String defaultMethodName() {
        String methodName = "parametersFor" + this.method.frameworkMethod.getName().substring(0, 1).toUpperCase() + this.method.frameworkMethod.getName().substring(1);
        return methodName;
    }

    Object currentParamsFromAnnotation() {
        return this.paramsFromAnnotation()[this.nextCount()];
    }

    void runTestMethod(Statement methodInvoker, RunNotifier notifier) {
        Description methodDescription = this.describeMethod();
        Description methodWithParams = this.findChildForParams(methodInvoker, methodDescription);
        notifier.fireTestStarted(methodWithParams);
        this.runMethodInvoker(notifier, methodDescription, methodInvoker, methodWithParams);
        notifier.fireTestFinished(methodWithParams);
    }

    Description describeMethod() {
        Object[] params = this.paramsFromAnnotation();
        Description parametrised = Description.createSuiteDescription((String)this.method.name(), (Annotation[])new Annotation[0]);
        for (int i = 0; i < params.length; ++i) {
            Object paramSet = params[i];
            parametrised.addChild(Description.createTestDescription(this.method.frameworkMethod.getMethod().getDeclaringClass(), (String)(Utils.stringify(paramSet, i) + " (" + this.method.name() + ")"), (Annotation[])this.method.frameworkMethod.getAnnotations()));
        }
        return parametrised;
    }

    private void runMethodInvoker(RunNotifier notifier, Description description, Statement methodInvoker, Description methodWithParams) {
        try {
            methodInvoker.evaluate();
        }
        catch (Throwable e) {
            notifier.fireTestFailure(new Failure(methodWithParams, e));
        }
    }

    private Description findChildForParams(Statement methodInvoker, Description methodDescription) {
        for (Description child : methodDescription.getChildren()) {
            InvokeParameterisedMethod parameterisedInvoker = this.findParameterisedMethodInvokerInChain(methodInvoker);
            if (!child.getMethodName().startsWith(parameterisedInvoker.getParamsAsString())) continue;
            return child;
        }
        return null;
    }

    private InvokeParameterisedMethod findParameterisedMethodInvokerInChain(Statement methodInvoker) {
        while (methodInvoker != null && !(methodInvoker instanceof InvokeParameterisedMethod)) {
            methodInvoker = this.nextChainedInvoker(methodInvoker);
        }
        if (methodInvoker == null) {
            throw new RuntimeException("Cannot find invoker for the parameterised method. Using wrong JUnit version?");
        }
        return (InvokeParameterisedMethod)methodInvoker;
    }

    private Statement nextChainedInvoker(Statement methodInvoker) {
        Field[] declaredFields;
        for (Field field : declaredFields = methodInvoker.getClass().getDeclaredFields()) {
            Statement statement = this.statementOrNull(methodInvoker, field);
            if (statement == null) continue;
            return statement;
        }
        return null;
    }

    private Statement statementOrNull(Statement methodInvoker, Field field) {
        if (field.getType().isAssignableFrom(Statement.class)) {
            return this.getOriginalStatement(methodInvoker, field);
        }
        return null;
    }

    private Statement getOriginalStatement(Statement methodInvoker, Field field) {
        field.setAccessible(true);
        try {
            return (Statement)field.get(methodInvoker);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

