/*
 * Decompiled with CFR 0.152.
 */
package junitparams;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junitparams.InvokeParameterisedMethod;
import junitparams.ParameterisedTestMethodRunner;
import junitparams.Parameters;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class ParameterisedTestClassRunner {
    private HashMap<FrameworkMethod, ParameterisedTestMethodRunner> parameterisedMethods = new HashMap();

    List<FrameworkMethod> computeTestMethods(List<FrameworkMethod> testMethods, boolean parameterisedOnlyOnce) {
        ArrayList<FrameworkMethod> resultMethods = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod testMethod : testMethods) {
            if (this.isParameterised(testMethod) && !parameterisedOnlyOnce) {
                this.addTestMethodForEachParamSet(resultMethods, testMethod);
                continue;
            }
            this.addTestMethodOnce(resultMethods, testMethod);
        }
        return resultMethods;
    }

    private void addTestMethodForEachParamSet(List<FrameworkMethod> resultMethods, FrameworkMethod testMethod) {
        ParameterisedTestMethodRunner parameterisedTestMethodRunner = new ParameterisedTestMethodRunner(testMethod);
        int paramSetSize = parameterisedTestMethodRunner.paramsFromAnnotation().length;
        for (int i = 0; i < paramSetSize; ++i) {
            this.addTestMethodOnce(resultMethods, testMethod);
        }
        this.parameterisedMethods.put(testMethod, parameterisedTestMethodRunner);
    }

    private void addTestMethodOnce(List<FrameworkMethod> resultMethods, FrameworkMethod testMethod) {
        resultMethods.add(testMethod);
    }

    Statement parameterisedMethodInvoker(FrameworkMethod method, Object test) {
        if (!this.isParameterised(method)) {
            return null;
        }
        ParameterisedTestMethodRunner parameterisedMethod = this.parameterisedMethods.get(method);
        return new InvokeParameterisedMethod(method, test, parameterisedMethod.currentParamsFromAnnotation(), parameterisedMethod.count());
    }

    boolean runParameterisedTest(FrameworkMethod method, Statement methodInvoker, RunNotifier notifier) {
        if (!this.isParameterised(method)) {
            return false;
        }
        this.parameterisedMethods.get(method).runTestMethod(methodInvoker, notifier);
        return true;
    }

    Description describeParameterisedMethod(FrameworkMethod method) {
        if (!this.isParameterised(method)) {
            return null;
        }
        return this.parameterisedMethods.get(method).describeMethod();
    }

    private boolean isParameterised(FrameworkMethod method) {
        return method.getMethod().isAnnotationPresent(Parameters.class);
    }
}

