/*
 * Decompiled with CFR 0.152.
 */
package junitparams;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.type.NullType;
import junitparams.InvokeParameterisedMethod;
import junitparams.Parameters;
import junitparams.Utils;
import org.junit.Test;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class JUnitParamsRunner
extends BlockJUnit4ClassRunner {
    private HashMap<FrameworkMethod, Integer> paramSetIndexMap;

    public JUnitParamsRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (this.isParameterised(method)) {
            this.runParameterisedScenario(method, notifier);
        } else {
            super.runChild(method, notifier);
        }
    }

    private void runParameterisedScenario(FrameworkMethod method, RunNotifier notifier) {
        Statement methodInvoker = this.methodBlock(method);
        Description methodDescription = this.describeParameterisedMethod(method);
        Description methodWithParams = this.findChildForParams(methodInvoker, methodDescription);
        notifier.fireTestStarted(methodWithParams);
        this.runMethodInvoker(notifier, methodDescription, methodInvoker, methodWithParams);
        notifier.fireTestFinished(methodWithParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMethodInvoker(RunNotifier notifier, Description description, Statement methodInvoker, Description methodWithParams) {
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
        try {
            eachNotifier.fireTestStarted();
            methodInvoker.evaluate();
        }
        catch (Throwable e) {
            notifier.fireTestFailure(new Failure(methodWithParams, e));
        }
        finally {
            eachNotifier.fireTestFinished();
        }
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.addTestMethods(this.getTestClass().getAnnotatedMethods(Test.class), false);
    }

    private List<FrameworkMethod> addTestMethods(List<FrameworkMethod> testMethods, boolean parameterisedOnlyOnce) {
        ArrayList<FrameworkMethod> resultMethods = new ArrayList<FrameworkMethod>();
        this.paramSetIndexMap = new HashMap();
        for (FrameworkMethod testMethod : testMethods) {
            if (this.isParameterised(testMethod) && !parameterisedOnlyOnce) {
                this.addTestMethodForEachParamSet(resultMethods, testMethod);
                continue;
            }
            this.addTestMethodOnce(resultMethods, testMethod);
        }
        return resultMethods;
    }

    private void addTestMethodForEachParamSet(List<FrameworkMethod> resultMethods, FrameworkMethod scenarioMethod) {
        int paramSetSize = this.paramsFromAnnotation(scenarioMethod).length;
        for (int i = 0; i < paramSetSize; ++i) {
            this.addTestMethodOnce(resultMethods, scenarioMethod);
        }
        this.paramSetIndexMap.put(scenarioMethod, 0);
    }

    private void addTestMethodOnce(List<FrameworkMethod> resultMethods, FrameworkMethod scenarioMethod) {
        resultMethods.add(scenarioMethod);
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        if (this.isParameterised(method)) {
            Integer counter = this.paramSetIndexMap.get(method);
            this.paramSetIndexMap.put(method, counter + 1);
            return new InvokeParameterisedMethod(method, test, this.paramsFromAnnotation(method)[counter]);
        }
        return super.methodInvoker(method, test);
    }

    public Description getDescription() {
        Description description = Description.createSuiteDescription((String)this.getName(), (Annotation[])this.getTestClass().getAnnotations());
        List<FrameworkMethod> resultMethods = this.addTestMethods(this.getTestClass().getAnnotatedMethods(Test.class), true);
        for (FrameworkMethod method : resultMethods) {
            description.addChild(this.describeMethod(method));
        }
        return description;
    }

    private Description describeMethod(FrameworkMethod method) {
        Description child = this.isParameterised(method) ? this.describeParameterisedMethod(method) : this.describeChild(method);
        return child;
    }

    private boolean isParameterised(FrameworkMethod method) {
        return method.getMethod().isAnnotationPresent(Parameters.class);
    }

    private Description describeParameterisedMethod(FrameworkMethod method) {
        Object[] params = this.paramsFromAnnotation(method);
        Description parametrised = Description.createSuiteDescription((String)this.testName(method), (Annotation[])new Annotation[0]);
        for (Object paramSet : params) {
            parametrised.addChild(Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)(Utils.stringify(paramSet) + " (" + this.testName(method) + ")"), (Annotation[])method.getAnnotations()));
        }
        return parametrised;
    }

    private Object[] paramsFromAnnotation(FrameworkMethod method) {
        Parameters parametersAnnotation = (Parameters)method.getAnnotation(Parameters.class);
        Object[] params = this.paramsFromValue(parametersAnnotation);
        if (params.length == 0) {
            params = this.paramsFromSource(parametersAnnotation);
        }
        if (params.length == 0) {
            params = this.paramsFromMethod(parametersAnnotation, method);
        }
        if (params.length == 0) {
            throw new RuntimeException("No parameters found, even though the method is defined as Prameterised. There aren't any params in the annotation, there's no test class method providing the params and no external provider...");
        }
        return params;
    }

    private Object[] paramsFromMethod(Parameters parametersAnnotation, FrameworkMethod method) {
        String methodName = parametersAnnotation.method();
        try {
            Class<?> testClass = method.getMethod().getDeclaringClass();
            Object testObject = testClass.newInstance();
            if ("".equals(methodName)) {
                methodName = "parametersFor" + method.getName().substring(0, 1).toUpperCase() + method.getName().substring(1);
            }
            Method provideMethod = testClass.getDeclaredMethod(methodName, new Class[0]);
            provideMethod.setAccessible(true);
            return (Object[])provideMethod.invoke(testObject, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find method: " + methodName + " so no params were used.", e);
        }
    }

    private Object[] paramsFromValue(Parameters parametersAnnotation) {
        Object[] params = parametersAnnotation.value();
        return params;
    }

    private Object[] paramsFromSource(Parameters parametersAnnotation) {
        if (!parametersAnnotation.source().isAssignableFrom(NullType.class)) {
            Method[] methods;
            Class<?> sourceClass = parametersAnnotation.source();
            ArrayList<Object> result = new ArrayList<Object>();
            for (Method method : methods = sourceClass.getDeclaredMethods()) {
                if (!method.getName().startsWith("provide")) continue;
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new RuntimeException("Parameters source method " + method.getName() + " is not declared as static. Modify it to a static method.");
                }
                try {
                    result.addAll(Arrays.asList((Object[])method.invoke(null, new Object[0])));
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot invoke parameters source method: " + method.getName(), e);
                }
            }
            if (result.isEmpty()) {
                throw new RuntimeException("No methods starting with provide or they return no result in the parameters source class: " + sourceClass.getName());
            }
            return result.toArray(new Object[0]);
        }
        return JUnitParamsRunner.$(new Object[0]);
    }

    private Description findChildForParams(Statement methodInvoker, Description methodDescription) {
        for (Description child : methodDescription.getChildren()) {
            InvokeParameterisedMethod parameterisedInvoker = this.findParameterisedMethodInvokerInChain(methodInvoker);
            if (!child.getMethodName().startsWith(parameterisedInvoker.getParamsAsString())) continue;
            return child;
        }
        return null;
    }

    private InvokeParameterisedMethod findParameterisedMethodInvokerInChain(Statement methodInvoker) {
        while (methodInvoker != null && !(methodInvoker instanceof InvokeParameterisedMethod)) {
            methodInvoker = this.nextChainedInvoker(methodInvoker);
        }
        if (methodInvoker == null) {
            throw new RuntimeException("Cannot find invoker for the parameterised method. Using wrong JUnit version?");
        }
        return (InvokeParameterisedMethod)methodInvoker;
    }

    private Statement nextChainedInvoker(Statement methodInvoker) {
        try {
            Field methodInvokerField = methodInvoker.getClass().getDeclaredField("fNext");
            methodInvokerField.setAccessible(true);
            return (Statement)methodInvokerField.get(methodInvoker);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object[] $(Object ... params) {
        return params;
    }
}

