/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.interfacer.maven;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import pl.matsuo.interfacer.core.InterfacesAdder;
import pl.matsuo.interfacer.maven.JavaParserMavenUtils;

@Mojo(name="add-interfaces", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class InterfacerPluginMojo
extends AbstractMojo {
    @Parameter
    String interfacePackage;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    File interfacesDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/avro")
    File scanDirectory;
    @Parameter(property="project", required=true, readonly=true)
    MavenProject project;

    public void execute() throws MojoExecutionException {
        JavaParserMavenUtils.makeJavaParserLogToMavenOutput(this.getLog());
        try {
            new InterfacesAdder().addInterfacesAllFiles(this.scanDirectory, this.interfacesDirectory, this.interfacePackage, this.project.getRuntimeClasspathElements());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error occurred", e);
        }
    }
}

