/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.interfacer.model.ref;

import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.matsuo.core.util.collection.CollectionUtil;
import pl.matsuo.interfacer.model.ref.MethodReference;
import pl.matsuo.interfacer.model.tv.TypeVariableReference;

public class ReflectionMethodReference
implements MethodReference {
    private static final Logger log = LoggerFactory.getLogger(ReflectionMethodReference.class);
    final Method method;
    final TypeSolver typeSolver;

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public Map<String, String> matches(MethodDeclaration methodDeclaration, Map<String, TypeVariableReference> typeVariables) {
        if (!this.returnTypeMatches(methodDeclaration)) {
            return null;
        }
        if (!this.parametersMatch(methodDeclaration)) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, String> resultConstraints = ReflectionMethodReference.typeConstraints(methodDeclaration.getType(), this.method.getGenericReturnType());
        Map<String, String> parameterConstraints = ReflectionMethodReference.typeConstraints(CollectionUtil.map((Collection)methodDeclaration.getParameters(), Parameter::getType), this.method.getGenericParameterTypes());
        result.putAll(resultConstraints);
        result.putAll(parameterConstraints);
        return result;
    }

    public static Map<String, String> typeConstraints(List<com.github.javaparser.ast.type.Type> params, Type[] generics) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < params.size(); ++i) {
            Map<String, String> partialConstraints = ReflectionMethodReference.typeConstraints(params.get(i), generics[i]);
            result.putAll(partialConstraints);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> typeConstraints(com.github.javaparser.ast.type.Type param, Type generic) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (generic instanceof ParameterizedType) {
            log.info("ParameterizedType " + generic);
            if (!(param instanceof ClassOrInterfaceType)) throw new RuntimeException("Not implemented yet");
            List typeArguments = ((ClassOrInterfaceType)param).getTypeArguments().map(types -> new ArrayList(types)).orElse(new ArrayList());
            result.putAll(ReflectionMethodReference.typeConstraints(typeArguments, ((ParameterizedType)generic).getActualTypeArguments()));
            return result;
        } else if (generic instanceof TypeVariable) {
            log.info("TypeVariable " + generic);
            result.put(((TypeVariable)generic).getName(), param.resolve().describe());
            return result;
        } else {
            log.info("Not a generic: " + generic + " for concrete: " + param);
        }
        return result;
    }

    private boolean parametersMatch(MethodDeclaration methodDeclaration) {
        for (int i = 0; i < this.method.getParameterCount(); ++i) {
            Class<?> paramType = this.method.getParameters()[i].getType();
            ResolvedType resolvedType = methodDeclaration.getParameter(i).getType().resolve();
            if (ReflectionFactory.typeDeclarationFor(paramType, (TypeSolver)this.typeSolver).isAssignableBy(resolvedType)) continue;
            return false;
        }
        return true;
    }

    private boolean returnTypeMatches(MethodDeclaration methodDeclaration) {
        ResolvedReferenceTypeDeclaration resolvedReferenceTypeDeclaration;
        return !(this.method.getReturnType().isPrimitive() ? !methodDeclaration.getType().toString().equals(this.method.getReturnType().getName()) : !(resolvedReferenceTypeDeclaration = ReflectionFactory.typeDeclarationFor(this.method.getReturnType(), (TypeSolver)this.typeSolver)).isAssignableBy(methodDeclaration.getType().resolve()));
    }

    public ReflectionMethodReference(Method method, TypeSolver typeSolver) {
        this.method = method;
        this.typeSolver = typeSolver;
    }
}

