/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.interfacer.model.ifc;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import pl.matsuo.core.util.collection.CollectionUtil;
import pl.matsuo.interfacer.model.ifc.IfcResolve;
import pl.matsuo.interfacer.model.ref.MethodReference;
import pl.matsuo.interfacer.model.tv.TypeVariableReference;

public abstract class AbstractIfcResolve
implements IfcResolve {
    @Override
    public Map<String, String> matches(ClassOrInterfaceDeclaration declaration) {
        List<MethodReference> methods = this.getMethods();
        if (methods.isEmpty()) {
            return null;
        }
        List<Map<String, String>> typeVariableMappings = this.getTypeVariableMappings(declaration, methods);
        if (typeVariableMappings.size() != methods.size()) {
            return null;
        }
        AtomicBoolean incompatible = new AtomicBoolean();
        HashMap<String, String> result = new HashMap<String, String>();
        typeVariableMappings.forEach(mapping -> {
            mapping.forEach((key, value) -> {
                if (result.containsKey(key) && !((String)result.get(key)).equals(value)) {
                    incompatible.set(true);
                }
            });
            result.putAll((Map<String, String>)mapping);
        });
        return incompatible.get() ? null : result;
    }

    protected List<Map<String, String>> getTypeVariableMappings(ClassOrInterfaceDeclaration declaration, List<MethodReference> methods) {
        Map<String, TypeVariableReference> typeVariables = this.typeVariables();
        return CollectionUtil.filterMap(methods, method -> this.findMatchingMethodTypeVariables(declaration, typeVariables, (MethodReference)method));
    }

    private Map<String, String> findMatchingMethodTypeVariables(ClassOrInterfaceDeclaration declaration, Map<String, TypeVariableReference> typeVariables, MethodReference method) {
        return (Map)CollectionUtil.getFirst((Collection)CollectionUtil.filterMap((Collection)declaration.getMethodsByName(method.getName()), methodDeclaration -> method.matches((MethodDeclaration)methodDeclaration, typeVariables)), Objects::nonNull);
    }

    protected abstract Map<String, TypeVariableReference> typeVariables();
}

