/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.interfacer.core;

import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.utils.SourceRoot;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.matsuo.interfacer.model.ifc.IfcResolve;
import pl.matsuo.interfacer.model.ifc.TypeDeclarationIfcResolve;

public class SourceInterfacesScanner {
    private static final Logger log = LoggerFactory.getLogger(SourceInterfacesScanner.class);

    public List<IfcResolve> scanInterfacesFromSrc(ParserConfiguration parserConfiguration, File interfacesDirectory) {
        ArrayList<IfcResolve> ifcs = new ArrayList<IfcResolve>();
        if (interfacesDirectory == null) {
            return ifcs;
        }
        SourceRoot source = new SourceRoot(interfacesDirectory.toPath(), parserConfiguration);
        try {
            for (ParseResult parseResult : source.tryToParse()) {
                if (parseResult.isSuccessful()) {
                    parseResult.getResult().ifPresent(cu -> {
                        IfcResolve ifcResolve = this.getIfcResolve((CompilationUnit)cu);
                        if (ifcResolve != null) {
                            ifcs.add(ifcResolve);
                        }
                    });
                    continue;
                }
                log.warn("Parse failure for " + parseResult.getProblems());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from source directory", e);
        }
        return ifcs;
    }

    public IfcResolve getIfcResolve(CompilationUnit compilationUnit) {
        return compilationUnit.getPrimaryType().filter(BodyDeclaration::isClassOrInterfaceDeclaration).map(type -> (ClassOrInterfaceDeclaration)type).filter(ClassOrInterfaceDeclaration::isInterface).map(type -> new TypeDeclarationIfcResolve(compilationUnit, (ClassOrInterfaceDeclaration)type)).orElse(null);
    }
}

