/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.interfacer.core;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ClassLoaderTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import java.io.File;
import java.util.List;
import lombok.NonNull;
import pl.matsuo.interfacer.core.ClasspathInterfacesScanner;

public class ParsingContext {
    final ClassLoader classLoader;
    final CombinedTypeSolver typeSolver;
    final ParserConfiguration parserConfiguration;
    final JavaParser javaParser;

    public ParsingContext(List<String> compileClasspathElements, @NonNull File scanDirectory, @NonNull File interfacesDirectory) {
        if (scanDirectory == null) {
            throw new NullPointerException("scanDirectory is marked non-null but is null");
        }
        if (interfacesDirectory == null) {
            throw new NullPointerException("interfacesDirectory is marked non-null but is null");
        }
        this.classLoader = ClasspathInterfacesScanner.getCompileClassLoader(compileClasspathElements);
        this.typeSolver = this.createTypeSolver(scanDirectory, interfacesDirectory, this.classLoader);
        this.parserConfiguration = new ParserConfiguration();
        this.parserConfiguration.setSymbolResolver((SymbolResolver)new JavaSymbolSolver((TypeSolver)this.typeSolver));
        this.javaParser = new JavaParser(this.parserConfiguration);
    }

    public CombinedTypeSolver createTypeSolver(File scanDirectory, File interfacesDirectory, ClassLoader classLoader) {
        CombinedTypeSolver combinedTypeSolver = new CombinedTypeSolver(new TypeSolver[0]);
        combinedTypeSolver.add((TypeSolver)new ClassLoaderTypeSolver(classLoader));
        combinedTypeSolver.add((TypeSolver)new JavaParserTypeSolver(scanDirectory.toPath()));
        combinedTypeSolver.add((TypeSolver)new JavaParserTypeSolver(interfacesDirectory.toPath()));
        return combinedTypeSolver;
    }
}

