/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.interfacer.core;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.utils.SourceRoot;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.matsuo.core.util.collection.CollectionUtil;
import pl.matsuo.core.util.collection.Pair;
import pl.matsuo.interfacer.core.ClasspathInterfacesScanner;
import pl.matsuo.interfacer.core.ParsingContext;
import pl.matsuo.interfacer.core.SourceInterfacesScanner;
import pl.matsuo.interfacer.model.ifc.IfcResolve;

public class InterfacesAdder {
    private static final Logger log = LoggerFactory.getLogger(InterfacesAdder.class);

    public void addInterfacesAllFiles(@NonNull File scanDirectory, File interfacesDirectory, String interfacePackage, List<String> compileClasspathElements) {
        if (scanDirectory == null) {
            throw new NullPointerException("scanDirectory is marked non-null but is null");
        }
        if (interfacesDirectory == null && (interfacePackage == null || compileClasspathElements == null)) {
            throw new RuntimeException("No interface source defined: interfacesDirectory " + interfacesDirectory + " interfacePackage " + interfacePackage + " compileClasspathElements " + compileClasspathElements);
        }
        log.info("Start processing");
        try {
            List<Pair<IfcResolve, ClassOrInterfaceDeclaration>> modifications;
            ArrayList<Pair<IfcResolve, ClassOrInterfaceDeclaration>> allModifications = new ArrayList<Pair<IfcResolve, ClassOrInterfaceDeclaration>>();
            while (!(modifications = this.addInterfacesAllFiles(scanDirectory, interfacesDirectory, interfacePackage, compileClasspathElements, allModifications)).isEmpty()) {
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from source directory", e);
        }
    }

    private List<Pair<IfcResolve, ClassOrInterfaceDeclaration>> addInterfacesAllFiles(File scanDirectory, File interfacesDirectory, String interfacePackage, List<String> compileClasspathElements, List<Pair<IfcResolve, ClassOrInterfaceDeclaration>> allModifications) throws IOException {
        ParsingContext parsingContext = new ParsingContext(compileClasspathElements, scanDirectory, interfacesDirectory);
        SourceRoot source = new SourceRoot(scanDirectory.toPath(), parsingContext.parserConfiguration);
        List<IfcResolve> ifcs = this.scanInterfaces(interfacesDirectory, interfacePackage, parsingContext);
        List<Pair<IfcResolve, ClassOrInterfaceDeclaration>> modifications = this.processAllFiles(source.tryToParse(), ifcs, parsingContext.javaParser);
        allModifications.addAll(modifications);
        source.saveAll();
        return modifications;
    }

    public ParseResult<CompilationUnit> parseFile(JavaParser javaParser, File file) {
        try {
            return javaParser.parse(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public List<IfcResolve> scanInterfaces(File interfacesDirectory, String interfacePackage, ParsingContext parsingContext) {
        ArrayList<IfcResolve> ifcs = new ArrayList<IfcResolve>();
        ifcs.addAll(new ClasspathInterfacesScanner().scanInterfacesFromClasspath(parsingContext.classLoader, interfacePackage, (TypeSolver)parsingContext.typeSolver));
        ifcs.addAll(new SourceInterfacesScanner().scanInterfacesFromSrc(parsingContext.parserConfiguration, interfacesDirectory));
        Comparator<IfcResolve> comparator = Comparator.comparing(i -> -i.getMethods().size());
        ifcs.sort(comparator);
        return ifcs;
    }

    public List<Pair<IfcResolve, ClassOrInterfaceDeclaration>> processAllFiles(List<ParseResult<CompilationUnit>> parseResults, List<IfcResolve> ifcs, JavaParser javaParser) {
        return CollectionUtil.flatMap(parseResults, parseResult -> {
            if (parseResult.isSuccessful()) {
                return parseResult.getResult().map(cu -> this.addInterfaces((CompilationUnit)cu, ifcs, javaParser)).orElse(Collections.emptyList());
            }
            log.warn("Parse failure for " + parseResult.getProblems());
            return Collections.emptyList();
        });
    }

    public List<Pair<IfcResolve, ClassOrInterfaceDeclaration>> addInterfaces(CompilationUnit compilationUnit, List<IfcResolve> ifcs, JavaParser javaParser) {
        return compilationUnit.getPrimaryType().map(primaryType -> primaryType.isClassOrInterfaceDeclaration() ? (ClassOrInterfaceDeclaration)primaryType : null).filter(declaration -> !declaration.isInterface()).map(declaration -> CollectionUtil.filterMap((Collection)ifcs, ifc -> this.processDeclarationWithInterface((ClassOrInterfaceDeclaration)declaration, (IfcResolve)ifc, javaParser))).orElse(Collections.emptyList());
    }

    public Pair<IfcResolve, ClassOrInterfaceDeclaration> processDeclarationWithInterface(ClassOrInterfaceDeclaration declaration, IfcResolve ifc, JavaParser javaParser) {
        Map<String, String> resolvedTypeVariables = ifc.matches(declaration);
        boolean canBeAssignedTo = this.canBeAssignedTo(declaration, ifc);
        if (resolvedTypeVariables != null && !canBeAssignedTo) {
            return this.addInterfaceToClassDeclaration(declaration, ifc, javaParser, resolvedTypeVariables);
        }
        return null;
    }

    private Pair<IfcResolve, ClassOrInterfaceDeclaration> addInterfaceToClassDeclaration(ClassOrInterfaceDeclaration declaration, IfcResolve ifc, JavaParser javaParser, Map<String, String> resolvedTypeVariables) {
        log.info("Modifying the class: " + declaration.getFullyQualifiedName() + " with ifc " + ifc.getName());
        ClassOrInterfaceType type = (ClassOrInterfaceType)javaParser.parseClassOrInterfaceType(ifc.getGenericName(resolvedTypeVariables)).getResult().orElseThrow(() -> new RuntimeException(""));
        declaration.addImplementedType(type);
        return Pair.pair((Object)ifc, (Object)declaration);
    }

    private boolean canBeAssignedTo(ClassOrInterfaceDeclaration declaration, IfcResolve ifc) {
        return CollectionUtil.anyMatch((Collection)declaration.resolve().getAncestors(), ancestor -> {
            try {
                return ifc.getResolvedTypeDeclaration().isAssignableBy((ResolvedType)ancestor);
            }
            catch (RuntimeException e) {
                return false;
            }
        });
    }
}

