/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.interfacer.core;

import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.matsuo.core.util.collection.CollectionUtil;
import pl.matsuo.interfacer.model.ifc.ClassIfcResolve;
import pl.matsuo.interfacer.model.ifc.IfcResolve;

public class ClasspathInterfacesScanner {
    private static final Logger log = LoggerFactory.getLogger(ClasspathInterfacesScanner.class);

    public List<IfcResolve> scanInterfacesFromClasspath(ClassLoader classLoader, String interfacePackage, TypeSolver typeSolver) {
        if (interfacePackage == null) {
            return Collections.emptyList();
        }
        String[] interfacePackages = interfacePackage.split(",");
        Reflections reflections = this.createReflections(classLoader, interfacePackages);
        return CollectionUtil.filterMap((Collection)reflections.getSubTypesOf(Object.class), type -> this.processClassFromClasspath((Class<?>)type, typeSolver));
    }

    public IfcResolve processClassFromClasspath(Class<?> type, TypeSolver typeSolver) {
        log.info("Processing classpath type: " + type.getCanonicalName());
        if (type.isInterface()) {
            log.info("Adding interface: " + type.getName());
            return new ClassIfcResolve(type, typeSolver);
        }
        return null;
    }

    public Reflections createReflections(ClassLoader classLoader, String[] interfacePackages) {
        FilterBuilder filterBuilder = new FilterBuilder();
        for (String interfacePackage : interfacePackages) {
            filterBuilder = filterBuilder.includePackage(interfacePackage);
        }
        return new Reflections((Configuration)new ConfigurationBuilder().addClassLoaders(new ClassLoader[]{classLoader}).setUrls(ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[]{classLoader})).setScanners(new Scanner[]{new SubTypesScanner(false)}).filterInputsBy((Predicate)filterBuilder));
    }

    public static ClassLoader getCompileClassLoader(List<String> compileClasspathElements) {
        List jars = CollectionUtil.map(compileClasspathElements, ClasspathInterfacesScanner::toUrl);
        jars.forEach(element -> log.info("Compile classloader entry: " + element));
        return new URLClassLoader(jars.toArray(new URL[0]));
    }

    public static URL toUrl(String name) {
        try {
            return new File(name).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

