/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.templ4docx.insert;

import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import pl.jsolve.templ4docx.insert.Insert;
import pl.jsolve.templ4docx.util.Key;

public abstract class ParagraphInsert
extends Insert {
    private XWPFTableCell cellParent;
    private XWPFDocument documentParent;
    private XWPFParagraph paragraph;

    public ParagraphInsert(Key key, XWPFParagraph paragraph, XWPFTableCell cellParent, XWPFDocument documentParent) {
        super(key);
        this.paragraph = paragraph;
        this.cellParent = cellParent;
        this.documentParent = documentParent;
    }

    public boolean deleteMe() {
        if (this.cellParent != null) {
            List p = this.cellParent.getParagraphs();
            for (int i = 0; i < p.size(); ++i) {
                if (!((XWPFParagraph)p.get(i)).equals(this.paragraph)) continue;
                this.cellParent.removeParagraph(i);
                return true;
            }
        } else if (this.documentParent != null) {
            int posOfParagraph = this.documentParent.getPosOfParagraph(this.paragraph);
            this.documentParent.removeBodyElement(posOfParagraph);
            return true;
        }
        return false;
    }

    public XWPFTableCell getCellParent() {
        return this.cellParent;
    }

    public XWPFDocument getDocumentParent() {
        return this.documentParent;
    }

    public XWPFParagraph getParagraph() {
        return this.paragraph;
    }
}

