/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.templ4docx.variable;

import java.util.List;
import java.util.Map;
import pl.jsolve.sweetener.collection.Collections;
import pl.jsolve.sweetener.collection.Maps;
import pl.jsolve.templ4docx.util.Key;
import pl.jsolve.templ4docx.variable.BulletListVariable;
import pl.jsolve.templ4docx.variable.ImageVariable;
import pl.jsolve.templ4docx.variable.TableVariable;
import pl.jsolve.templ4docx.variable.TextVariable;
import pl.jsolve.templ4docx.variable.Variable;

public class Variables {
    private Map<String, TextVariable> textVariables = Maps.newHashMap();
    private Map<String, ImageVariable> imageVariables = Maps.newHashMap();
    private List<TableVariable> tableVariables = Collections.newArrayList();
    private Map<String, BulletListVariable> bulletListVariables = Maps.newHashMap();

    public TextVariable addTextVariable(TextVariable textVariable) {
        return this.textVariables.put(textVariable.getKey(), textVariable);
    }

    public ImageVariable addImageVariable(ImageVariable imageVariable) {
        return this.imageVariables.put(imageVariable.getKey(), imageVariable);
    }

    public TableVariable addTableVariable(TableVariable tableVariable) {
        this.tableVariables.add(tableVariable);
        return tableVariable;
    }

    public BulletListVariable addBulletListVariable(BulletListVariable bulletListVariable) {
        this.bulletListVariables.put(bulletListVariable.getKey(), bulletListVariable);
        return bulletListVariable;
    }

    public Map<String, TextVariable> getTextVariables() {
        return this.textVariables;
    }

    public Map<String, ImageVariable> getImageVariables() {
        return this.imageVariables;
    }

    public List<TableVariable> getTableVariables() {
        return this.tableVariables;
    }

    public Map<String, BulletListVariable> getBulletListVariables() {
        return this.bulletListVariables;
    }

    public Variable getVariable(Key key) {
        switch (key.getVariableType()) {
            case TEXT: {
                return this.textVariables.get(key.getKey());
            }
            case IMAGE: {
                return this.imageVariables.get(key.getKey());
            }
            case TABLE: {
                for (Key subkey : key.getSubKeys()) {
                    for (TableVariable tableVariable : this.tableVariables) {
                        if (!tableVariable.containsKey(subkey.getKey())) continue;
                        return tableVariable;
                    }
                }
                break;
            }
            case BULLET_LIST: {
                return this.bulletListVariables.get(key.getKey());
            }
        }
        return null;
    }
}

