/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.templ4docx.extractor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import pl.jsolve.sweetener.collection.Collections;
import pl.jsolve.templ4docx.util.Key;
import pl.jsolve.templ4docx.util.VariableType;
import pl.jsolve.templ4docx.variable.TableVariable;
import pl.jsolve.templ4docx.variable.TextVariable;
import pl.jsolve.templ4docx.variable.Variable;
import pl.jsolve.templ4docx.variable.Variables;

public class KeyExtractor {
    public List<Key> extractKeys(Variables variables) {
        ArrayList keys = Collections.newArrayList();
        for (Map.Entry<String, TextVariable> entry : variables.getTextVariables().entrySet()) {
            keys.add(new Key(entry.getKey(), VariableType.TEXT));
        }
        for (Map.Entry<String, Variable> entry : variables.getImageVariables().entrySet()) {
            keys.add(new Key(entry.getKey(), VariableType.IMAGE));
        }
        for (TableVariable tableVariable : variables.getTableVariables()) {
            for (Key key : tableVariable.getKeys()) {
                Key tableKey = new Key(key.getKey(), VariableType.TABLE);
                tableKey.addSubKey(key);
                keys.add(tableKey);
            }
        }
        for (Map.Entry entry : variables.getBulletListVariables().entrySet()) {
            keys.add(new Key((String)entry.getKey(), VariableType.BULLET_LIST));
        }
        return keys;
    }
}

