/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.templ4docx.core;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import pl.jsolve.sweetener.text.Strings;
import pl.jsolve.templ4docx.core.VariablePattern;

public class RunExtractor {
    public void execute(List<XWPFRun> runs, String[] keyArray, String[] valueArray, VariablePattern variablePattern) {
        if (runs == null || runs.isEmpty()) {
            return;
        }
        if (runs.size() == 1) {
            XWPFRun xwpfRun = runs.get(0);
            String text = xwpfRun.getText(0);
            if (text != null) {
                text = StringUtils.replaceEach((String)text, (String[])keyArray, (String[])valueArray);
                xwpfRun.setText(text, 0);
            }
        } else {
            for (XWPFRun xwpfRun : runs) {
                String text = xwpfRun.getText(0);
                if (text == null) continue;
                text = StringUtils.replaceEach((String)text, (String[])keyArray, (String[])valueArray);
                xwpfRun.setText(text, 0);
            }
            String notRecognizedVariable = "";
            String notRecognizedVariablePrefix = "";
            int notRecognizedVariableStartIndex = -1;
            for (int i = 0; i < runs.size(); ++i) {
                String prefix;
                String text = runs.get(i).getText(0);
                if (text == null) continue;
                text = text.trim();
                if (notRecognizedVariableStartIndex != -1) {
                    if (!Strings.indexesOf((String)text, (String)variablePattern.getSuffix()).isEmpty()) {
                        notRecognizedVariable = notRecognizedVariable + text.substring(0, (Integer)Strings.indexesOf((String)text, (String)variablePattern.getSuffix()).get(0) + 1);
                        notRecognizedVariable = StringUtils.replaceEach((String)notRecognizedVariable, (String[])keyArray, (String[])valueArray);
                        XWPFRun startRun = runs.get(notRecognizedVariableStartIndex);
                        String textFromStartRun = startRun.getText(0);
                        textFromStartRun = textFromStartRun.replace(notRecognizedVariablePrefix, notRecognizedVariable);
                        startRun.setText(textFromStartRun, 0);
                        for (int j = notRecognizedVariableStartIndex + 1; j < i; ++j) {
                            runs.get(j).setText("", 0);
                        }
                        text = runs.get(i).getText(0);
                        Integer suffixIndex = (Integer)Strings.indexesOf((String)text, (String)variablePattern.getSuffix()).get(0);
                        runs.get(i).setText(text.substring(suffixIndex + 1), 0);
                        i = notRecognizedVariableStartIndex;
                        notRecognizedVariableStartIndex = -1;
                        notRecognizedVariable = "";
                        notRecognizedVariablePrefix = "";
                        continue;
                    }
                    notRecognizedVariable = notRecognizedVariable + text;
                }
                if (Strings.indexesOf((String)text, (String)(prefix = this.getFirstChar(variablePattern.getPrefix()))).isEmpty() || !Strings.indexesOf((String)text, (String)variablePattern.getSuffix()).isEmpty()) continue;
                notRecognizedVariableStartIndex = i;
                notRecognizedVariable = text;
                List indexesOf = Strings.indexesOf((String)text, (String)prefix);
                Integer prefixIndex = (Integer)indexesOf.get(0);
                notRecognizedVariablePrefix = text.substring(prefixIndex);
            }
        }
    }

    private String getFirstChar(String prefix) {
        if (prefix.length() == 1) {
            return prefix;
        }
        if (prefix.startsWith("\\") && prefix.length() > 1) {
            return prefix.substring(0, 2);
        }
        return prefix.substring(0, 1);
    }
}

