/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.templ4docx.core;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import pl.jsolve.sweetener.io.Resources;
import pl.jsolve.templ4docx.core.Docx;
import pl.jsolve.templ4docx.core.VariablePattern;
import pl.jsolve.templ4docx.core.VariablesExtractor;
import pl.jsolve.templ4docx.exception.OpenDocxException;

public class DocxTemplate {
    private VariablePattern variablePattern = new VariablePattern("${", "}");

    public Docx openTemplate(String path) {
        return new Docx(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readTextContent(Docx docx) {
        XWPFWordExtractor extractor = null;
        try {
            extractor = new XWPFWordExtractor(docx.getDocument());
            String string = extractor.getText();
            return string;
        }
        finally {
            if (extractor != null) {
                Resources.closeStream((Closeable)extractor);
            }
        }
    }

    public List<String> findVariables(Docx docx) {
        VariablesExtractor extractor = new VariablesExtractor();
        String content = this.readTextContent(docx);
        return extractor.extract(content, this.variablePattern);
    }

    public Docx fillTemplate(String path, Map<String, String> templateVariables) {
        Docx docx = this.openTemplate(path);
        this.fillTemplate(docx, templateVariables);
        return docx;
    }

    public void fillTemplate(Docx docx, Map<String, String> templateVariables) {
        try {
            VariablesExtractor extractor = new VariablesExtractor();
            extractor.replaceVariables(docx, templateVariables, this.variablePattern);
        }
        catch (Exception e) {
            throw new OpenDocxException(e.getMessage(), e.getCause());
        }
    }

    public void save(Docx docx, String outputPath) {
        try {
            docx.getDocument().write((OutputStream)new FileOutputStream(outputPath));
        }
        catch (Exception ex) {
            throw new OpenDocxException(ex.getMessage(), ex.getCause());
        }
    }

    public void save(Docx docx, OutputStream outputStream) {
        try {
            docx.getDocument().write(outputStream);
        }
        catch (Exception ex) {
            throw new OpenDocxException(ex.getMessage(), ex.getCause());
        }
    }

    public void setVariablePattern(VariablePattern variablePattern) {
        this.variablePattern = variablePattern;
    }
}

