/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import pl.edu.icm.jlargearrays.ByteLargeArray;
import pl.edu.icm.jlargearrays.ComplexDoubleLargeArray;
import pl.edu.icm.jlargearrays.ComplexFloatLargeArray;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.IntLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LogicLargeArray;
import pl.edu.icm.jlargearrays.LongLargeArray;
import pl.edu.icm.jlargearrays.ObjectLargeArray;
import pl.edu.icm.jlargearrays.ShortLargeArray;
import pl.edu.icm.jlargearrays.StringLargeArray;
import sun.misc.Unsafe;

public class Utilities {
    public static final Unsafe UNSAFE;

    private Utilities() {
    }

    public static void arraycopy(LargeArray src, long srcPos, LargeArray dest, long destPos, long length) {
        if (src.getType() != dest.getType()) {
            throw new IllegalArgumentException("The type of source array is different than the type of destimation array.");
        }
        switch (src.getType()) {
            case LOGIC: {
                Utilities.arraycopy((LogicLargeArray)src, srcPos, (LogicLargeArray)dest, destPos, length);
                break;
            }
            case BYTE: {
                Utilities.arraycopy((ByteLargeArray)src, srcPos, (ByteLargeArray)dest, destPos, length);
                break;
            }
            case SHORT: {
                Utilities.arraycopy((ShortLargeArray)src, srcPos, (ShortLargeArray)dest, destPos, length);
                break;
            }
            case INT: {
                Utilities.arraycopy((IntLargeArray)src, srcPos, (IntLargeArray)dest, destPos, length);
                break;
            }
            case LONG: {
                Utilities.arraycopy((LongLargeArray)src, srcPos, (LongLargeArray)dest, destPos, length);
                break;
            }
            case FLOAT: {
                Utilities.arraycopy((FloatLargeArray)src, srcPos, (FloatLargeArray)dest, destPos, length);
                break;
            }
            case DOUBLE: {
                Utilities.arraycopy((DoubleLargeArray)src, srcPos, (DoubleLargeArray)dest, destPos, length);
                break;
            }
            case COMPLEX_FLOAT: {
                Utilities.arraycopy((ComplexFloatLargeArray)src, srcPos, (ComplexFloatLargeArray)dest, destPos, length);
                break;
            }
            case COMPLEX_DOUBLE: {
                Utilities.arraycopy((ComplexDoubleLargeArray)src, srcPos, (ComplexDoubleLargeArray)dest, destPos, length);
                break;
            }
            case STRING: {
                Utilities.arraycopy((StringLargeArray)src, srcPos, (StringLargeArray)dest, destPos, length);
                break;
            }
            case OBJECT: {
                Utilities.arraycopy((ObjectLargeArray)src, srcPos, (ObjectLargeArray)dest, destPos, length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid array type.");
            }
        }
    }

    public static void arraycopy(Object src, long srcPos, LargeArray dest, long destPos, long length) {
        switch (dest.getType()) {
            case LOGIC: {
                Utilities.arraycopy((boolean[])src, (int)srcPos, (LogicLargeArray)dest, destPos, length);
                break;
            }
            case BYTE: {
                Utilities.arraycopy((byte[])src, (int)srcPos, (ByteLargeArray)dest, destPos, length);
                break;
            }
            case SHORT: {
                Utilities.arraycopy((short[])src, (int)srcPos, (ShortLargeArray)dest, destPos, length);
                break;
            }
            case INT: {
                Utilities.arraycopy((int[])src, (int)srcPos, (IntLargeArray)dest, destPos, length);
                break;
            }
            case LONG: {
                Utilities.arraycopy((long[])src, (int)srcPos, (LongLargeArray)dest, destPos, length);
                break;
            }
            case FLOAT: {
                Utilities.arraycopy((float[])src, (int)srcPos, (FloatLargeArray)dest, destPos, length);
                break;
            }
            case DOUBLE: {
                Utilities.arraycopy((double[])src, (int)srcPos, (DoubleLargeArray)dest, destPos, length);
                break;
            }
            case COMPLEX_FLOAT: {
                Utilities.arraycopy((float[])src, (int)srcPos, (ComplexFloatLargeArray)dest, destPos, length);
                break;
            }
            case COMPLEX_DOUBLE: {
                Utilities.arraycopy((double[])src, (int)srcPos, (ComplexDoubleLargeArray)dest, destPos, length);
                break;
            }
            case STRING: {
                Utilities.arraycopy((String[])src, (int)srcPos, (StringLargeArray)dest, destPos, length);
                break;
            }
            case OBJECT: {
                Utilities.arraycopy((Object[])src, (int)srcPos, (ObjectLargeArray)dest, destPos, length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid array type.");
            }
        }
    }

    public static void arraycopy(final LogicLargeArray src, final long srcPos, final LogicLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setByte(j, src.getByte(i));
                ++i;
                ++j;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setByte(destPos + k, src.getByte(srcPos + k));
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                long i = srcPos;
                long j2 = destPos;
                while (i < srcPos + length) {
                    dest.setByte(j2, src.getByte(i));
                    ++i;
                    ++j2;
                }
            }
        }
    }

    public static void arraycopy(final boolean[] src, final int srcPos, final LogicLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.setBoolean(j, src[i++]);
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setBoolean(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                for (long j2 = destPos; j2 < destPos + length; ++j2) {
                    dest.setBoolean(j2, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final ByteLargeArray src, final long srcPos, final ByteLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setByte(j, src.getByte(i));
                ++i;
                ++j;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setByte(destPos + k, src.getByte(srcPos + k));
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                long i = srcPos;
                long j2 = destPos;
                while (i < srcPos + length) {
                    dest.setByte(j2, src.getByte(i));
                    ++i;
                    ++j2;
                }
            }
        }
    }

    public static void arraycopy(final byte[] src, final int srcPos, final ByteLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.setByte(j, src[i++]);
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setByte(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                for (long j2 = destPos; j2 < destPos + length; ++j2) {
                    dest.setByte(j2, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final ShortLargeArray src, final long srcPos, final ShortLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setShort(j, src.getShort(i));
                ++i;
                ++j;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setShort(destPos + k, src.getShort(srcPos + k));
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                long i = srcPos;
                long j2 = destPos;
                while (i < srcPos + length) {
                    dest.setShort(j2, src.getShort(i));
                    ++i;
                    ++j2;
                }
            }
        }
    }

    public static void arraycopy(final short[] src, final int srcPos, final ShortLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.setShort(j, src[i++]);
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setShort(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                for (long j2 = destPos; j2 < destPos + length; ++j2) {
                    dest.setShort(j2, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final IntLargeArray src, final long srcPos, final IntLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setInt(j, src.getInt(i));
                ++i;
                ++j;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setInt(destPos + k, src.getInt(srcPos + k));
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                long i = srcPos;
                long j2 = destPos;
                while (i < srcPos + length) {
                    dest.setInt(j2, src.getInt(i));
                    ++i;
                    ++j2;
                }
            }
        }
    }

    public static void arraycopy(final int[] src, final int srcPos, final IntLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.setInt(j, src[i++]);
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setInt(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                for (long j2 = destPos; j2 < destPos + length; ++j2) {
                    dest.setInt(j2, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final LongLargeArray src, final long srcPos, final LongLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setLong(j, src.getLong(i));
                ++i;
                ++j;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setLong(destPos + k, src.getLong(srcPos + k));
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                long i = srcPos;
                long j2 = destPos;
                while (i < srcPos + length) {
                    dest.setLong(j2, src.getLong(i));
                    ++i;
                    ++j2;
                }
            }
        }
    }

    public static void arraycopy(final long[] src, final int srcPos, final LongLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.setLong(j, src[i++]);
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setLong(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                for (long j2 = destPos; j2 < destPos + length; ++j2) {
                    dest.setLong(j2, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final FloatLargeArray src, final long srcPos, final FloatLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setFloat(j, src.getFloat(i));
                ++i;
                ++j;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setFloat(destPos + k, src.getFloat(srcPos + k));
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                long i = srcPos;
                long j2 = destPos;
                while (i < srcPos + length) {
                    dest.setFloat(j2, src.getFloat(i));
                    ++i;
                    ++j2;
                }
            }
        }
    }

    public static void arraycopy(final float[] src, final int srcPos, final FloatLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.setFloat(j, src[i++]);
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setFloat(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                for (long j2 = destPos; j2 < destPos + length; ++j2) {
                    dest.setFloat(j2, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final DoubleLargeArray src, final long srcPos, final DoubleLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setDouble(j, src.getDouble(i));
                ++i;
                ++j;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setDouble(destPos + k, src.getDouble(srcPos + k));
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                long i = srcPos;
                long j2 = destPos;
                while (i < srcPos + length) {
                    dest.setDouble(j2, src.getDouble(i));
                    ++i;
                    ++j2;
                }
            }
        }
    }

    public static void arraycopy(final double[] src, final int srcPos, final DoubleLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.setDouble(j, src[i++]);
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setDouble(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                for (long j2 = destPos; j2 < destPos + length; ++j2) {
                    dest.setDouble(j2, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final ComplexFloatLargeArray src, final long srcPos, final ComplexFloatLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setComplexFloat(j, src.getComplexFloat(i));
                ++i;
                ++j;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setComplexFloat(destPos + k, src.getComplexFloat(srcPos + k));
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                long i = srcPos;
                long j2 = destPos;
                while (i < srcPos + length) {
                    dest.setComplexFloat(j2, src.getComplexFloat(i));
                    ++i;
                    ++j2;
                }
            }
        }
    }

    public static void arraycopy(final float[] src, final int srcPos, final ComplexFloatLargeArray dest, final long destPos, long length) {
        if (src.length % 2 != 0) {
            throw new IllegalArgumentException("The length of the source array must be even.");
        }
        if (srcPos < 0 || srcPos >= src.length / 2) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length / 2");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            float[] elem = new float[2];
            for (long j = destPos; j < destPos + length; ++j) {
                elem[0] = src[2 * i];
                elem[1] = src[2 * i + 1];
                dest.setComplexFloat(j, elem);
                ++i;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        float[] elem = new float[2];
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            elem[0] = src[2 * (srcPos + (int)k)];
                            elem[1] = src[2 * (srcPos + (int)k) + 1];
                            dest.setComplexFloat(destPos + k, elem);
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                float[] elem = new float[2];
                for (long j2 = destPos; j2 < destPos + length; ++j2) {
                    elem[0] = src[2 * i];
                    elem[1] = src[2 * i + 1];
                    dest.setComplexFloat(j2, elem);
                    ++i;
                }
            }
        }
    }

    public static void arraycopy(final ComplexDoubleLargeArray src, final long srcPos, final ComplexDoubleLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setComplexDouble(j, src.getComplexDouble(i));
                ++i;
                ++j;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setComplexDouble(destPos + k, src.getComplexDouble(srcPos + k));
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                long i = srcPos;
                long j2 = destPos;
                while (i < srcPos + length) {
                    dest.setComplexDouble(j2, src.getComplexDouble(i));
                    ++i;
                    ++j2;
                }
            }
        }
    }

    public static void arraycopy(final double[] src, final int srcPos, final ComplexDoubleLargeArray dest, final long destPos, long length) {
        if (src.length % 2 != 0) {
            throw new IllegalArgumentException("The length of the source array must be even.");
        }
        if (srcPos < 0 || srcPos >= src.length / 2) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length / 2");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            double[] elem = new double[2];
            for (long j = destPos; j < destPos + length; ++j) {
                elem[0] = src[2 * i];
                elem[1] = src[2 * i + 1];
                dest.setComplexDouble(j, elem);
                ++i;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        double[] elem = new double[2];
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            elem[0] = src[2 * (srcPos + (int)k)];
                            elem[1] = src[2 * (srcPos + (int)k) + 1];
                            dest.setComplexDouble(destPos + k, elem);
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                double[] elem = new double[2];
                for (long j2 = destPos; j2 < destPos + length; ++j2) {
                    elem[0] = src[2 * i];
                    elem[1] = src[2 * i + 1];
                    dest.setComplexDouble(j2, elem);
                    ++i;
                }
            }
        }
    }

    public static void arraycopy(final StringLargeArray src, final long srcPos, final StringLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.set(j, src.get(i));
                ++i;
                ++j;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.set(destPos + k, src.get(srcPos + k));
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                long i = srcPos;
                long j2 = destPos;
                while (i < srcPos + length) {
                    dest.set(j2, src.get(i));
                    ++i;
                    ++j2;
                }
            }
        }
    }

    public static void arraycopy(final String[] src, final int srcPos, final StringLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.set(j, src[i++]);
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.set(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                for (long j2 = destPos; j2 < destPos + length; ++j2) {
                    dest.set(j2, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final ObjectLargeArray src, final long srcPos, final ObjectLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.set(j, src.get(i));
                ++i;
                ++j;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.set(destPos + k, src.get(srcPos + k));
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                long i = srcPos;
                long j2 = destPos;
                while (i < srcPos + length) {
                    dest.set(j2, src.get(i));
                    ++i;
                    ++j2;
                }
            }
        }
    }

    public static void arraycopy(final Object[] src, final int srcPos, final ObjectLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        if (nthreads < 2 || length < 100000L) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.set(j, src[i++]);
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.set(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                for (long j2 = destPos; j2 < destPos + length; ++j2) {
                    dest.set(j2, src[i++]);
                }
            }
        }
    }

    public static LargeArray create(LargeArrayType type, long length) {
        return Utilities.create(type, length, true);
    }

    public static LargeArray create(LargeArrayType type, long length, boolean zeroNativeMemory) {
        switch (type) {
            case LOGIC: {
                return new LogicLargeArray(length, zeroNativeMemory);
            }
            case BYTE: {
                return new ByteLargeArray(length, zeroNativeMemory);
            }
            case SHORT: {
                return new ShortLargeArray(length, zeroNativeMemory);
            }
            case INT: {
                return new IntLargeArray(length, zeroNativeMemory);
            }
            case LONG: {
                return new LongLargeArray(length, zeroNativeMemory);
            }
            case FLOAT: {
                return new FloatLargeArray(length, zeroNativeMemory);
            }
            case DOUBLE: {
                return new DoubleLargeArray(length, zeroNativeMemory);
            }
            case COMPLEX_FLOAT: {
                return new ComplexFloatLargeArray(length, zeroNativeMemory);
            }
            case COMPLEX_DOUBLE: {
                return new ComplexDoubleLargeArray(length, zeroNativeMemory);
            }
            case STRING: {
                return new StringLargeArray(length, 100, zeroNativeMemory);
            }
            case OBJECT: {
                return new ObjectLargeArray(length, 100, zeroNativeMemory);
            }
        }
        throw new IllegalArgumentException("Invalid array type.");
    }

    public static LargeArray convert(final LargeArray src, final LargeArrayType type) {
        LargeArray out;
        block76: {
            int j;
            int nthreads;
            long length;
            block75: {
                if (src.getType() == type) {
                    return src;
                }
                if (src.isConstant()) {
                    switch (type) {
                        case LOGIC: {
                            return new LogicLargeArray(src.length(), src.getByte(0L));
                        }
                        case BYTE: {
                            return new ByteLargeArray(src.length(), src.getByte(0L));
                        }
                        case SHORT: {
                            return new ShortLargeArray(src.length(), src.getShort(0L));
                        }
                        case INT: {
                            return new IntLargeArray(src.length(), src.getInt(0L));
                        }
                        case LONG: {
                            return new LongLargeArray(src.length(), src.getLong(0L));
                        }
                        case FLOAT: {
                            return new FloatLargeArray(src.length(), src.getFloat(0L));
                        }
                        case DOUBLE: {
                            return new DoubleLargeArray(src.length(), src.getDouble(0L));
                        }
                        case COMPLEX_FLOAT: {
                            return new ComplexFloatLargeArray(src.length(), ((ComplexFloatLargeArray)src).getComplexFloat(0L));
                        }
                        case COMPLEX_DOUBLE: {
                            return new ComplexDoubleLargeArray(src.length(), ((ComplexDoubleLargeArray)src).getComplexDouble(0L));
                        }
                        case STRING: {
                            return new StringLargeArray(src.length(), src.get(0L).toString());
                        }
                        case OBJECT: {
                            return new ObjectLargeArray(src.length(), src.get(0L));
                        }
                    }
                    throw new IllegalArgumentException("Invalid array type.");
                }
                length = src.length;
                out = Utilities.create(type, length, false);
                nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
                if (nthreads >= 2 && length >= 100000L) break block75;
                switch (type) {
                    case LOGIC: 
                    case BYTE: {
                        for (long i = 0L; i < length; ++i) {
                            out.setByte(i, src.getByte(i));
                        }
                        break block76;
                    }
                    case SHORT: {
                        for (long i = 0L; i < length; ++i) {
                            out.setShort(i, src.getShort(i));
                        }
                        break block76;
                    }
                    case INT: {
                        for (long i = 0L; i < length; ++i) {
                            out.setInt(i, src.getInt(i));
                        }
                        break block76;
                    }
                    case LONG: {
                        for (long i = 0L; i < length; ++i) {
                            out.setLong(i, src.getLong(i));
                        }
                        break block76;
                    }
                    case FLOAT: {
                        for (long i = 0L; i < length; ++i) {
                            out.setFloat(i, src.getFloat(i));
                        }
                        break block76;
                    }
                    case DOUBLE: {
                        for (long i = 0L; i < length; ++i) {
                            out.setDouble(i, src.getDouble(i));
                        }
                        break block76;
                    }
                    case COMPLEX_FLOAT: {
                        if (src.getType() == LargeArrayType.COMPLEX_DOUBLE) {
                            for (long i = 0L; i < length; ++i) {
                                ((ComplexFloatLargeArray)out).setComplexDouble(i, ((ComplexDoubleLargeArray)src).getComplexDouble(i));
                            }
                        } else {
                            for (long i = 0L; i < length; ++i) {
                                out.setFloat(i, src.getFloat(i));
                            }
                        }
                        break block76;
                    }
                    case COMPLEX_DOUBLE: {
                        if (src.getType() == LargeArrayType.COMPLEX_FLOAT) {
                            for (long i = 0L; i < length; ++i) {
                                ((ComplexDoubleLargeArray)out).setComplexFloat(i, ((ComplexFloatLargeArray)src).getComplexFloat(i));
                            }
                        } else {
                            for (long i = 0L; i < length; ++i) {
                                out.setDouble(i, src.getDouble(i));
                            }
                        }
                        break block76;
                    }
                    case STRING: {
                        for (long i = 0L; i < length; ++i) {
                            out.set(i, src.get(i).toString());
                        }
                        break block76;
                    }
                    case OBJECT: {
                        for (long i = 0L; i < length; ++i) {
                            out.set(i, src.get(i));
                        }
                        break block76;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid array type.");
                    }
                }
            }
            long k = length / (long)nthreads;
            Thread[] threads = new Thread[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        switch (type) {
                            case BYTE: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setByte(i, src.getByte(i));
                                }
                                break;
                            }
                            case SHORT: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setShort(i, src.getShort(i));
                                }
                                break;
                            }
                            case INT: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setInt(i, src.getInt(i));
                                }
                                break;
                            }
                            case LONG: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setLong(i, src.getLong(i));
                                }
                                break;
                            }
                            case FLOAT: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setFloat(i, src.getFloat(i));
                                }
                                break;
                            }
                            case DOUBLE: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setDouble(i, src.getDouble(i));
                                }
                                break;
                            }
                            case COMPLEX_FLOAT: {
                                if (src.getType() == LargeArrayType.COMPLEX_DOUBLE) {
                                    for (long i = firstIdx; i < lastIdx; ++i) {
                                        ((ComplexFloatLargeArray)out).setComplexDouble(i, ((ComplexDoubleLargeArray)src).getComplexDouble(i));
                                    }
                                } else {
                                    for (long i = firstIdx; i < lastIdx; ++i) {
                                        out.setFloat(i, src.getFloat(i));
                                    }
                                }
                                break;
                            }
                            case COMPLEX_DOUBLE: {
                                if (src.getType() == LargeArrayType.COMPLEX_FLOAT) {
                                    for (long i = firstIdx; i < lastIdx; ++i) {
                                        ((ComplexDoubleLargeArray)out).setComplexFloat(i, ((ComplexFloatLargeArray)src).getComplexFloat(i));
                                    }
                                } else {
                                    for (long i = firstIdx; i < lastIdx; ++i) {
                                        out.setDouble(i, src.getDouble(i));
                                    }
                                }
                                break;
                            }
                            case STRING: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.set(i, src.get(i).toString());
                                }
                                break;
                            }
                            case OBJECT: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.set(i, src.get(i));
                                }
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid array type.");
                            }
                        }
                    }
                });
                threads[j].start();
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    threads[j].join();
                    threads[j] = null;
                }
            }
            catch (InterruptedException ex) {
                switch (type) {
                    case LOGIC: 
                    case BYTE: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.setByte(i, src.getByte(i));
                        }
                        break;
                    }
                    case SHORT: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.setShort(i, src.getShort(i));
                        }
                        break;
                    }
                    case INT: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.setInt(i, src.getInt(i));
                        }
                        break;
                    }
                    case LONG: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.setLong(i, src.getLong(i));
                        }
                        break;
                    }
                    case FLOAT: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.setFloat(i, src.getFloat(i));
                        }
                        break;
                    }
                    case DOUBLE: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.setDouble(i, src.getDouble(i));
                        }
                        break;
                    }
                    case COMPLEX_FLOAT: {
                        long i;
                        if (src.getType() == LargeArrayType.COMPLEX_DOUBLE) {
                            for (i = 0L; i < length; ++i) {
                                ((ComplexFloatLargeArray)out).setComplexDouble(i, ((ComplexDoubleLargeArray)src).getComplexDouble(i));
                            }
                        } else {
                            for (i = 0L; i < length; ++i) {
                                out.setFloat(i, src.getFloat(i));
                            }
                        }
                        break;
                    }
                    case COMPLEX_DOUBLE: {
                        long i;
                        if (src.getType() == LargeArrayType.COMPLEX_FLOAT) {
                            for (i = 0L; i < length; ++i) {
                                ((ComplexDoubleLargeArray)out).setComplexFloat(i, ((ComplexFloatLargeArray)src).getComplexFloat(i));
                            }
                        } else {
                            for (i = 0L; i < length; ++i) {
                                out.setDouble(i, src.getDouble(i));
                            }
                        }
                        break;
                    }
                    case STRING: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.set(i, src.get(i).toString());
                        }
                        break;
                    }
                    case OBJECT: {
                        long i;
                        for (i = 0L; i < length; ++i) {
                            out.set(i, src.get(i));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid array type.");
                    }
                }
            }
        }
        return out;
    }

    public static LargeArray select(LargeArray src, final LogicLargeArray mask) {
        long j;
        int j2;
        if (src.length != mask.length) {
            throw new IllegalArgumentException("src.length != mask.length");
        }
        long length = src.length;
        long count = 0L;
        int nthreads = (int)Math.min(length, (long)Runtime.getRuntime().availableProcessors());
        long k = length / (long)nthreads;
        ExecutorService pool = Executors.newCachedThreadPool();
        Future[] futures = new Future[nthreads];
        for (j2 = 0; j2 < nthreads; ++j2) {
            final long firstIdx = (long)j2 * k;
            final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
            futures[j2] = pool.submit(new Callable(){

                public Long call() {
                    long count = 0L;
                    for (long k = firstIdx; k < lastIdx; ++k) {
                        if (mask.getByte(k) != 1) continue;
                        ++count;
                    }
                    return count;
                }
            });
        }
        try {
            for (j2 = 0; j2 < nthreads; ++j2) {
                count += ((Long)futures[j2].get()).longValue();
            }
        }
        catch (Exception ex) {
            for (j = 0L; j < length; ++j) {
                if (mask.getByte(j) != 1) continue;
                ++count;
            }
        }
        if (count <= 0L) {
            return null;
        }
        LargeArray res = Utilities.create(src.getType(), count, false);
        k = 0L;
        for (j = 0L; j < length; ++j) {
            if (mask.getByte(j) != 1) continue;
            res.set(k++, src.get(j));
        }
        return res;
    }

    static {
        Object theUnsafe = null;
        Exception exception = null;
        try {
            Class<?> uc = Class.forName("sun.misc.Unsafe");
            Field f = uc.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            theUnsafe = f.get(uc);
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (IllegalArgumentException e) {
            exception = e;
        }
        catch (NoSuchFieldException e) {
            exception = e;
        }
        catch (SecurityException e) {
            exception = e;
        }
        UNSAFE = (Unsafe)theUnsafe;
        if (UNSAFE == null) {
            throw new Error("Could not obtain access to sun.misc.Unsafe", exception);
        }
    }
}

