/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.io.UnsupportedEncodingException;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.MemoryCounter;
import pl.edu.icm.jlargearrays.ShortLargeArray;
import pl.edu.icm.jlargearrays.Utilities;
import sun.misc.Cleaner;

public class StringLargeArray
extends LargeArray {
    private static final long serialVersionUID = -4096759496772248522L;
    private String[] data;
    private ShortLargeArray stringLengths;
    private int maxStringLength;
    private long size;
    private byte[] byteArray;
    private static final String CHARSET = "UTF-8";
    private static final int CHARSET_SIZE = 4;

    public StringLargeArray(long length) {
        this(length, 100);
    }

    public StringLargeArray(long length, int maxStringLength) {
        this(length, maxStringLength, true);
    }

    public StringLargeArray(long length, int maxStringLength, boolean zeroNativeMemory) {
        this.type = LargeArrayType.STRING;
        this.sizeof = 1L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value.");
        }
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException(maxStringLength + " is not a positive int value.");
        }
        this.length = length;
        this.size = length * (long)maxStringLength * 4L;
        this.maxStringLength = maxStringLength;
        if (length > (long)LARGEST_32BIT_INDEX) {
            System.gc();
            this.ptr = Utilities.UNSAFE.allocateMemory(this.size * this.sizeof);
            if (zeroNativeMemory) {
                this.zeroNativeMemory(this.size);
            }
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.size, this.sizeof));
            MemoryCounter.increaseCounter(this.size * this.sizeof);
            this.stringLengths = new ShortLargeArray(length);
            this.byteArray = new byte[maxStringLength * 4];
        } else {
            this.data = new String[(int)length];
        }
    }

    public StringLargeArray(long length, String constantValue) {
        this.type = LargeArrayType.STRING;
        this.sizeof = 1L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        this.isConstant = true;
        this.data = new String[]{constantValue};
    }

    public StringLargeArray(String[] data) {
        this.type = LargeArrayType.STRING;
        this.sizeof = 1L;
        this.length = data.length;
        this.data = data;
    }

    @Override
    public StringLargeArray clone() {
        if (this.isConstant()) {
            return new StringLargeArray(this.length, this.get(0L));
        }
        StringLargeArray v = new StringLargeArray(this.length, Math.max(1, this.maxStringLength), false);
        Utilities.arraycopy(this, 0L, v, 0L, this.length);
        return v;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            StringLargeArray la = (StringLargeArray)o;
            return this.maxStringLength == la.maxStringLength && this.data == la.data && this.stringLengths.equals(la.stringLengths);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 29 * super.hashCode() + (this.data != null ? this.data.hashCode() : 0);
        hash = 29 * hash + (this.maxStringLength ^ this.maxStringLength >>> 16);
        return 29 * hash + (this.stringLengths != null ? this.stringLengths.hashCode() : 0);
    }

    @Override
    public String get(long i) {
        if (this.ptr != 0L) {
            int strLen = this.stringLengths.getShort(i);
            if (strLen < 0) {
                return null;
            }
            long offset = this.sizeof * i * (long)this.maxStringLength * 4L;
            for (int j = 0; j < strLen; ++j) {
                this.byteArray[j] = Utilities.UNSAFE.getByte(this.ptr + offset + this.sizeof * (long)j);
            }
            try {
                return new String(this.byteArray, 0, strLen, CHARSET);
            }
            catch (UnsupportedEncodingException ex) {
                return null;
            }
        }
        if (this.isConstant()) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    @Override
    public String getFromNative(long i) {
        int strLen = this.stringLengths.getShort(i);
        if (strLen < 0) {
            return null;
        }
        long offset = this.sizeof * i * (long)this.maxStringLength * 4L;
        for (int j = 0; j < strLen; ++j) {
            this.byteArray[j] = Utilities.UNSAFE.getByte(this.ptr + offset + this.sizeof * (long)j);
        }
        try {
            return new String(this.byteArray, 0, strLen, CHARSET);
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    @Override
    public boolean getBoolean(long i) {
        String s = this.get(i);
        return s != null ? s.length() != 0 : false;
    }

    @Override
    public byte getByte(long i) {
        String s = this.get(i);
        return (byte)(s != null ? s.length() : 0);
    }

    @Override
    public short getShort(long i) {
        String s = this.get(i);
        return (short)(s != null ? s.length() : 0);
    }

    @Override
    public int getInt(long i) {
        String s = this.get(i);
        return s != null ? s.length() : 0;
    }

    @Override
    public long getLong(long i) {
        String s = this.get(i);
        return s != null ? s.length() : 0;
    }

    @Override
    public float getFloat(long i) {
        String s = this.get(i);
        return s != null ? s.length() : 0;
    }

    @Override
    public double getDouble(long i) {
        String s = this.get(i);
        return s != null ? s.length() : 0;
    }

    public String[] getData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)StringLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            String[] out = new String[(int)this.length];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[0];
                ++i;
            }
            return out;
        }
        return this.data;
    }

    @Override
    public boolean[] getBooleanData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)StringLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            boolean[] out = new boolean[(int)this.length];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[0] != null ? this.data[0].length() != 0 : false;
                ++i;
            }
            return out;
        }
        boolean[] out = new boolean[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            out[i] = this.data[i] != null ? this.data[i].length() != 0 : false;
            ++i;
        }
        return out;
    }

    @Override
    public boolean[] getBooleanData(boolean[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)StringLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        boolean[] out = a != null && (long)a.length >= len ? a : new boolean[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                short strLen = this.stringLengths.getShort(i);
                out[idx++] = strLen > 0;
            }
        } else if (this.isConstant()) {
            boolean elem = this.data[0] != null ? this.data[0].length() != 0 : false;
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = elem;
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                int v = this.data[(int)i] != null ? this.data[(int)i].length() : 0;
                out[idx++] = v != 0;
            }
        }
        return out;
    }

    @Override
    public byte[] getByteData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)StringLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            byte[] out = new byte[(int)this.length];
            byte elem = (byte)(this.data[0] != null ? this.data[0].length() : 0);
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
            return out;
        }
        byte[] res = new byte[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            res[i] = (byte)(this.data[i] != null ? this.data[i].length() : 0);
            ++i;
        }
        return res;
    }

    @Override
    public byte[] getByteData(byte[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)StringLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        byte[] out = a != null && (long)a.length >= len ? a : new byte[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (byte)this.stringLengths.getShort(i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (byte)(this.data[0] != null ? this.data[0].length() : 0);
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (byte)(this.data[(int)i] != null ? this.data[(int)i].length() : 0);
            }
        }
        return out;
    }

    @Override
    public short[] getShortData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)StringLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            short[] out = new short[(int)this.length];
            short elem = (short)(this.data[0] != null ? this.data[0].length() : 0);
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
            return out;
        }
        short[] res = new short[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            res[i] = (short)(this.data[i] != null ? this.data[i].length() : 0);
            ++i;
        }
        return res;
    }

    @Override
    public short[] getShortData(short[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)StringLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        short[] out = a != null && (long)a.length >= len ? a : new short[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.stringLengths.getShort(i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)(this.data[0] != null ? this.data[0].length() : 0);
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)(this.data[(int)i] != null ? this.data[(int)i].length() : 0);
            }
        }
        return out;
    }

    @Override
    public int[] getIntData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)StringLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            int[] out = new int[(int)this.length];
            int elem = this.data[0] != null ? this.data[0].length() : 0;
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
            return out;
        }
        int[] res = new int[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            res[i] = this.data[i] != null ? this.data[i].length() : 0;
            ++i;
        }
        return res;
    }

    @Override
    public int[] getIntData(int[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)StringLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        int[] out = a != null && (long)a.length >= len ? a : new int[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.stringLengths.getShort(i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0] != null ? this.data[0].length() : 0;
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i] != null ? this.data[(int)i].length() : 0;
            }
        }
        return out;
    }

    @Override
    public long[] getLongData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)StringLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            long[] out = new long[(int)this.length];
            long elem = this.data[0] != null ? this.data[0].length() : 0;
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
            return out;
        }
        long[] res = new long[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            res[i] = this.data[i] != null ? this.data[i].length() : 0;
            ++i;
        }
        return res;
    }

    @Override
    public long[] getLongData(long[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)StringLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        long[] out = a != null && (long)a.length >= len ? a : new long[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.stringLengths.getShort(i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0] != null ? this.data[0].length() : 0;
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i] != null ? this.data[(int)i].length() : 0;
            }
        }
        return out;
    }

    @Override
    public float[] getFloatData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)StringLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            float[] out = new float[(int)this.length];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[0] != null ? (float)this.data[0].length() : 0.0f;
                ++i;
            }
            return out;
        }
        float[] out = new float[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            out[i] = this.data[i] != null ? this.data[i].length() : 0;
            ++i;
        }
        return out;
    }

    @Override
    public float[] getFloatData(float[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)StringLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        float[] out = a != null && (long)a.length >= len ? a : new float[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.stringLengths.getShort(i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0] != null ? (float)this.data[0].length() : 0.0f;
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i] != null ? this.data[(int)i].length() : 0;
            }
        }
        return out;
    }

    @Override
    public double[] getDoubleData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)StringLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            double[] out = new double[(int)this.length];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[0] != null ? (double)this.data[0].length() : 0.0;
                ++i;
            }
            return out;
        }
        double[] out = new double[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            out[i] = this.data[i] != null ? this.data[i].length() : 0;
            ++i;
        }
        return out;
    }

    @Override
    public double[] getDoubleData(double[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)StringLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        double[] out = a != null && (long)a.length >= len ? a : new double[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.stringLengths.getShort(i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0] != null ? (double)this.data[0].length() : 0.0;
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i] != null ? this.data[(int)i].length() : 0;
            }
        }
        return out;
    }

    @Override
    public void setToNative(long i, Object o) {
        if (o == null) {
            this.stringLengths.setShort(i, (short)-1);
        } else {
            byte[] tmp;
            if (!(o instanceof String)) {
                throw new IllegalArgumentException(o + " is not a string.");
            }
            String s = (String)o;
            if (s.length() > this.maxStringLength) {
                throw new IllegalArgumentException("String  " + s + " is too long.");
            }
            try {
                tmp = s.getBytes(CHARSET);
            }
            catch (UnsupportedEncodingException ex) {
                return;
            }
            int strLen = tmp.length;
            if (strLen > Short.MAX_VALUE) {
                throw new IllegalArgumentException("String  " + s + " is too long.");
            }
            this.stringLengths.setShort(i, (short)strLen);
            long offset = this.sizeof * i * (long)this.maxStringLength * 4L;
            for (int j = 0; j < strLen; ++j) {
                Utilities.UNSAFE.putByte(this.ptr + offset + this.sizeof * (long)j, tmp[j]);
            }
        }
    }

    @Override
    public void set(long i, Object o) {
        if (o == null) {
            if (this.ptr != 0L) {
                this.stringLengths.setShort(i, (short)-1);
            } else {
                if (this.isConstant()) {
                    throw new IllegalAccessError("Constant arrays cannot be modified.");
                }
                this.data[(int)i] = null;
            }
        } else {
            if (!(o instanceof String)) {
                throw new IllegalArgumentException(o + " is not a string.");
            }
            String s = (String)o;
            if (this.ptr != 0L) {
                byte[] tmp;
                if (s.length() > this.maxStringLength) {
                    throw new IllegalArgumentException("String  " + s + " is too long.");
                }
                try {
                    tmp = s.getBytes(CHARSET);
                }
                catch (UnsupportedEncodingException ex) {
                    return;
                }
                int strLen = tmp.length;
                if (strLen > Short.MAX_VALUE) {
                    throw new IllegalArgumentException("String  " + s + " is too long.");
                }
                this.stringLengths.setShort(i, (short)strLen);
                long offset = this.sizeof * i * (long)this.maxStringLength * 4L;
                for (int j = 0; j < strLen; ++j) {
                    Utilities.UNSAFE.putByte(this.ptr + offset + this.sizeof * (long)j, tmp[j]);
                }
            } else {
                if (this.isConstant()) {
                    throw new IllegalAccessError("Constant arrays cannot be modified.");
                }
                this.data[(int)i] = s;
            }
        }
    }

    @Override
    public void set_safe(long i, Object o) {
        if (i < 0L || i >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(i));
        }
        this.set(i, o);
    }

    @Override
    public void setBoolean(long i, boolean value) {
        this.set(i, Boolean.toString(value));
    }

    @Override
    public void setByte(long i, byte value) {
        this.set(i, Byte.toString(value));
    }

    @Override
    public void setShort(long i, short value) {
        this.set(i, Short.toString(value));
    }

    @Override
    public void setInt(long i, int value) {
        this.set(i, Integer.toString(value));
    }

    @Override
    public void setLong(long i, long value) {
        this.set(i, Long.toString(value));
    }

    @Override
    public void setFloat(long i, float value) {
        this.set(i, Float.toString(value));
    }

    @Override
    public void setDouble(long i, double value) {
        this.set(i, Double.toString(value));
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }
}

